/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class FileKeystoreService
implements Service<KeyStore> {
    public static final String KEYSTORE_SUFFIX = "keystore";
    public static final String TRUSTSTORE_SUFFIX = "truststore";
    private KeyStore theKeyStore;
    private final String path;
    private final char[] password;
    private final InjectedValue<String> relativeTo = new InjectedValue();

    public FileKeystoreService(String path, char[] password) {
        this.path = path;
        this.password = password;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(StartContext ctx) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        FileInputStream fis = null;
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            fis = new FileInputStream(file);
            keystore.load(fis, this.password);
            this.theKeyStore = keystore;
            this.safeClose(fis);
            return;
        }
        catch (KeyStoreException e) {
            try {
                throw DomainManagementMessages.MESSAGES.unableToStart(e);
                catch (NoSuchAlgorithmException e2) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e2);
                }
                catch (CertificateException e3) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e3);
                }
                catch (IOException e4) {
                    throw DomainManagementMessages.MESSAGES.unableToStart(e4);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(fis);
                throw throwable;
            }
        }
    }

    public void stop(StopContext ctx) {
        this.theKeyStore = null;
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.theKeyStore;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    private void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

