/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.SecurityActions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalOperationHandlers {
    public static final OperationStepHandler READ_RESOURCE = new ReadResourceHandler();
    public static final OperationStepHandler READ_ATTRIBUTE = new ReadAttributeHandler();
    public static final OperationStepHandler READ_CHILDREN_NAMES = new ReadChildrenNamesOperationHandler();
    public static final OperationStepHandler READ_CHILDREN_RESOURCES = new ReadChildrenResourcesOperationHandler();
    public static final OperationStepHandler UNDEFINE_ATTRIBUTE = new UndefineAttributeHandler();
    public static final OperationStepHandler WRITE_ATTRIBUTE = new WriteAttributeHandler();
    public static final OperationStepHandler READ_CHILDREN_TYPES = new OperationStepHandler(){

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            TreeSet<String> childTypes = new TreeSet<String>(registry.getChildNames(PathAddress.EMPTY_ADDRESS));
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String key : childTypes) {
                result.add(key);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    };
    public static final OperationStepHandler READ_OPERATION_NAMES = new OperationStepHandler(){

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            Map<String, OperationEntry> operations = registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, true);
            ModelNode result = new ModelNode();
            if (operations.size() > 0) {
                for (Map.Entry<String, OperationEntry> entry : operations.entrySet()) {
                    if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC || context.getProcessType() == ProcessType.DOMAIN_SERVER && !entry.getValue().getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) continue;
                    result.add(entry.getKey());
                }
            } else {
                result.setEmptyList();
            }
            context.getResult().set(result);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    };
    public static final OperationStepHandler READ_OPERATION_DESCRIPTION = new OperationStepHandler(){

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName = operation.require("name").asString();
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            OperationEntry operationEntry = registry.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
            if (operationEntry == null || context.getProcessType() == ProcessType.DOMAIN_SERVER && !operationEntry.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.operationNotRegistered(operationName, PathAddress.pathAddress(operation.require("address")))));
            }
            ModelNode result = operationEntry.getDescriptionProvider().getModelDescription(GlobalOperationHandlers.getLocale(context, operation));
            EnumSet<OperationEntry.Flag> flags = operationEntry.getFlags();
            boolean readOnly = flags.contains((Object)OperationEntry.Flag.READ_ONLY);
            result.get("read-only").set(readOnly);
            if (!readOnly) {
                if (flags.contains((Object)OperationEntry.Flag.RESTART_ALL_SERVICES)) {
                    result.get("restart-required").set("all-services");
                } else if (flags.contains((Object)OperationEntry.Flag.RESTART_RESOURCE_SERVICES)) {
                    result.get("restart-required").set("resource-services");
                } else if (flags.contains((Object)OperationEntry.Flag.RESTART_JVM)) {
                    result.get("restart-required").set("jvm");
                }
            }
            context.getResult().set(result);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    };
    public static final OperationStepHandler READ_RESOURCE_DESCRIPTION = new OperationStepHandler(){
        private final ParametersValidator validator = new ParametersValidator();
        {
            this.validator.registerValidator("recursive", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("recursive-depth", new ModelTypeValidator(ModelType.INT, true));
            this.validator.registerValidator("proxies", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("operations", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("inherited", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            if (address.isMultiTarget()) {
                ModelNode result = context.getResult().setEmptyList();
                context.addStep(new ModelNode(), AbstractMultiTargetHandler.FAKE_OPERATION.clone(), new RegistrationAddressResolver(operation, result, new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        this.doExecute(context, operation);
                    }
                }), OperationContext.Stage.IMMEDIATE);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            } else {
                this.doExecute(context, operation);
            }
        }

        void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validate(operation);
            String opName = operation.require("operation").asString();
            ModelNode opAddr = operation.get("address");
            PathAddress address = PathAddress.pathAddress(opAddr);
            int recursiveDepth = operation.get("recursive-depth").asInt(0);
            boolean recursive = recursiveDepth > 0 ? true : operation.get("recursive").asBoolean(false);
            boolean proxies = operation.get("proxies").asBoolean(false);
            boolean ops = operation.get("operations").asBoolean(false);
            boolean inheritedOps = operation.get("inherited").asBoolean(true);
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
            Locale locale = GlobalOperationHandlers.getLocale(context, operation);
            ModelNode nodeDescription = descriptionProvider.getModelDescription(locale);
            HashMap<String, ModelNode> operations = new HashMap<String, ModelNode>();
            HashMap<PathElement, ModelNode> childResources = recursive ? new HashMap<PathElement, ModelNode>() : Collections.emptyMap();
            ReadResourceDescriptionAssemblyHandler assemblyHandler = new ReadResourceDescriptionAssemblyHandler(nodeDescription, operations, childResources);
            context.addStep(assemblyHandler, OperationContext.Stage.IMMEDIATE);
            if (ops) {
                for (Map.Entry<String, OperationEntry> entry : registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, inheritedOps).entrySet()) {
                    if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC || context.getProcessType() == ProcessType.DOMAIN_SERVER && !entry.getValue().getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) continue;
                    DescriptionProvider provider = entry.getValue().getDescriptionProvider();
                    operations.put(entry.getKey(), provider.getModelDescription(locale));
                }
            }
            if (nodeDescription.hasDefined("attributes")) {
                for (String attr : nodeDescription.require("attributes").keys()) {
                    AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
                    AttributeAccess.AccessType accessType = access == null ? AttributeAccess.AccessType.READ_ONLY : access.getAccessType();
                    AttributeAccess.Storage storage = access == null ? AttributeAccess.Storage.CONFIGURATION : access.getStorageType();
                    ModelNode attrNode = nodeDescription.get(new String[]{"attributes", attr});
                    String displayedAccessType = context.getProcessType() == ProcessType.DOMAIN_SERVER && storage == AttributeAccess.Storage.CONFIGURATION ? AttributeAccess.AccessType.READ_ONLY.toString() : accessType.toString();
                    attrNode.get("access-type").set(displayedAccessType);
                    attrNode.get("storage").set(storage.toString());
                    if (accessType != AttributeAccess.AccessType.READ_WRITE) continue;
                    Set<AttributeAccess.Flag> flags = access.getFlags();
                    if (flags.contains((Object)AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
                        attrNode.get("restart-required").set("all-services");
                        continue;
                    }
                    if (flags.contains((Object)AttributeAccess.Flag.RESTART_RESOURCE_SERVICES)) {
                        attrNode.get("restart-required").set("resource-services");
                        continue;
                    }
                    if (flags.contains((Object)AttributeAccess.Flag.RESTART_JVM)) {
                        attrNode.get("restart-required").set("jvm");
                        continue;
                    }
                    attrNode.get("restart-required").set("no-services");
                }
            }
            if (recursive) {
                for (PathElement element : registry.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
                    PathAddress relativeAddr = PathAddress.pathAddress(element);
                    ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                    boolean readChild = true;
                    if (childReg.isRemote() && !proxies) {
                        readChild = false;
                    }
                    if (readChild) {
                        int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                        ModelNode rrOp = new ModelNode();
                        rrOp.get("operation").set(opName);
                        try {
                            rrOp.get("address").set(PathAddress.pathAddress(address, element).toModelNode());
                        }
                        catch (Exception e) {
                            continue;
                        }
                        rrOp.get("recursive").set(operation.get("recursive"));
                        rrOp.get("recursive-depth").set(newDepth);
                        rrOp.get("proxies").set(proxies);
                        rrOp.get("operations").set(ops);
                        rrOp.get("inherited").set(inheritedOps);
                        rrOp.get("locale").set(operation.get("locale"));
                        ModelNode rrRsp = new ModelNode();
                        childResources.put(element, rrRsp);
                        OperationStepHandler handler = childReg.isRemote() ? childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName) : new OperationStepHandler(){

                            @Override
                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                this.doExecute(context, operation);
                            }
                        };
                        context.addStep(rrRsp, rrOp, handler, OperationContext.Stage.IMMEDIATE);
                    }
                    nodeDescription.get(new String[]{"children", element.getKey(), "model-description", element.getValue()});
                }
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    };

    private GlobalOperationHandlers() {
    }

    private static ModelNode safeReadModel(OperationContext context) {
        try {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ModelNode result = resource.getModel();
            if (result.isDefined()) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ModelNode().setEmptyObject();
    }

    private static Map<String, Set<String>> getChildAddresses(ImmutableManagementResourceRegistration registry, Resource resource, String validChildType) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set<PathElement> elements = registry.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        for (PathElement element : elements) {
            ImmutableManagementResourceRegistration childReg;
            String childType = element.getKey();
            if (validChildType != null && !validChildType.equals(childType)) continue;
            LinkedHashSet<String> set = (LinkedHashSet<String>)result.get(childType);
            if (set == null) {
                set = new LinkedHashSet<String>();
                result.put(childType, set);
                if (resource.hasChildren(childType)) {
                    set.addAll(resource.getChildrenNames(childType));
                }
            }
            if (element.isWildcard() || (childReg = registry.getSubModel(PathAddress.pathAddress(element))) == null || !childReg.isRuntimeOnly()) continue;
            set.add(element.getValue());
        }
        return result;
    }

    private static Locale getLocale(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("locale")) {
            return null;
        }
        String unparsed = GlobalOperationHandlers.normalizeLocale(operation.get("locale").asString());
        int len = unparsed.length();
        if (len != 2 && len != 5 && len < 7) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        char char0 = unparsed.charAt(0);
        char char1 = unparsed.charAt(1);
        if (char0 < 'a' || char0 > 'z' || char1 < 'a' || char1 > 'z') {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        if (len == 2) {
            return new Locale(unparsed, "");
        }
        if (!GlobalOperationHandlers.isLocaleSeparator(unparsed.charAt(2))) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        char char3 = unparsed.charAt(3);
        if (GlobalOperationHandlers.isLocaleSeparator(char3)) {
            return new Locale(unparsed.substring(0, 2), "", unparsed.substring(4));
        }
        char char4 = unparsed.charAt(4);
        if (char3 < 'A' || char3 > 'Z' || char4 < 'A' || char4 > 'Z') {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        if (len == 5) {
            return new Locale(unparsed.substring(0, 2), unparsed.substring(3));
        }
        if (!GlobalOperationHandlers.isLocaleSeparator(unparsed.charAt(5))) {
            GlobalOperationHandlers.reportInvalidLocaleFormat(context, unparsed);
            return null;
        }
        return new Locale(unparsed.substring(0, 2), unparsed.substring(3, 5), unparsed.substring(6));
    }

    private static String normalizeLocale(String toNormalize) {
        return "zh_Hans".equalsIgnoreCase(toNormalize) || "zh-Hans".equalsIgnoreCase(toNormalize) ? "zh_CN" : toNormalize;
    }

    private static boolean isLocaleSeparator(char ch) {
        return ch == '-' || ch == '_';
    }

    private static void reportInvalidLocaleFormat(OperationContext context, String format) {
        String msg = ControllerMessages.MESSAGES.invalidLocaleString(format);
        ControllerLogger.MGMT_OP_LOGGER.debug(msg);
    }

    static class RegistrationAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final OperationStepHandler handler;

        RegistrationAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(address, PathAddress.EMPTY_ADDRESS, context);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        void execute(PathAddress address, PathAddress base, OperationContext context) {
            PathAddress current = address.subAddress(base.size());
            Iterator iterator = current.iterator();
            if (iterator.hasNext()) {
                PathElement element = (PathElement)iterator.next();
                if (element.isMultiTarget()) {
                    Set<PathElement> children = context.getResourceRegistration().getChildAddresses(base);
                    if (children == null || children.isEmpty()) {
                        return;
                    }
                    String childType = element.getKey().equals("*") ? null : element.getKey();
                    for (PathElement path : children) {
                        if (childType != null && !childType.equals(path.getKey())) continue;
                        this.execute(address, base.append(path), context);
                    }
                } else {
                    this.execute(address, base.append(element), context);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                ModelNode result = this.result.add();
                result.get("address").set(base.toModelNode());
                context.addStep(result, newOp, this.handler, OperationContext.Stage.IMMEDIATE);
            }
        }
    }

    public static final class ModelAddressResolver
    implements OperationStepHandler {
        private final ModelNode operation;
        private final ModelNode result;
        private final OperationStepHandler handler;

        public ModelAddressResolver(ModelNode operation, ModelNode result, OperationStepHandler delegate) {
            this.operation = operation;
            this.result = result;
            this.handler = delegate;
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(this.operation.require("address"));
            this.execute(address, PathAddress.EMPTY_ADDRESS, context);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        void execute(PathAddress address, PathAddress base, OperationContext context) {
            Resource resource = context.readResource(base, false);
            PathAddress current = address.subAddress(base.size());
            Iterator iterator = current.iterator();
            if (iterator.hasNext()) {
                PathElement element = (PathElement)iterator.next();
                if (element.isMultiTarget()) {
                    String childType = element.getKey().equals("*") ? null : element.getKey();
                    ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(base);
                    if (registration.isRemote() || registration.isRuntimeOnly()) {
                        throw new IllegalStateException();
                    }
                    Map resolved = GlobalOperationHandlers.getChildAddresses(registration, resource, childType);
                    for (Map.Entry entry : resolved.entrySet()) {
                        String key = (String)entry.getKey();
                        Set children = (Set)entry.getValue();
                        if (children.isEmpty()) continue;
                        if (element.isWildcard()) {
                            for (String child : children) {
                                if (!resource.hasChild(PathElement.pathElement(key, child))) continue;
                                this.execute(address, base.append(PathElement.pathElement(key, child)), context);
                            }
                            continue;
                        }
                        for (String segment : element.getSegments()) {
                            if (!children.contains(segment) || !resource.hasChild(PathElement.pathElement(key, segment))) continue;
                            this.execute(address, base.append(PathElement.pathElement(key, segment)), context);
                        }
                    }
                } else if (resource.hasChild(element)) {
                    this.execute(address, base.append(element), context);
                }
            } else {
                ModelNode newOp = this.operation.clone();
                newOp.get("address").set(base.toModelNode());
                ModelNode result = this.result.add();
                result.get("address").set(base.toModelNode());
                context.addStep(result, newOp, this.handler, OperationContext.Stage.IMMEDIATE);
            }
        }
    }

    public static abstract class AbstractMultiTargetHandler
    implements OperationStepHandler {
        public static final ModelNode FAKE_OPERATION;

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            if (address.isMultiTarget()) {
                ModelNode result = context.getResult().setEmptyList();
                context.addStep(new ModelNode(), FAKE_OPERATION.clone(), new ModelAddressResolver(operation, result, new OperationStepHandler(){

                    @Override
                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        AbstractMultiTargetHandler.this.doExecute(context, operation);
                    }
                }), OperationContext.Stage.IMMEDIATE);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            } else {
                this.doExecute(context, operation);
            }
        }

        abstract void doExecute(OperationContext var1, ModelNode var2) throws OperationFailedException;

        static {
            ModelNode resolve = new ModelNode();
            resolve.get("operation").set("resolve");
            resolve.get("address").setEmptyList();
            resolve.protect();
            FAKE_OPERATION = resolve;
        }
    }

    private static class ReadResourceDescriptionAssemblyHandler
    implements OperationStepHandler {
        private final ModelNode nodeDescription;
        private final Map<String, ModelNode> operations;
        private final Map<PathElement, ModelNode> childResources;

        private ReadResourceDescriptionAssemblyHandler(ModelNode nodeDescription, Map<String, ModelNode> operations, Map<PathElement, ModelNode> childResources) {
            this.nodeDescription = nodeDescription;
            this.operations = operations;
            this.childResources = childResources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            for (Map.Entry<PathElement, ModelNode> entry : this.childResources.entrySet()) {
                PathElement element = entry.getKey();
                ModelNode value = entry.getValue();
                if (!value.has("failure-description")) {
                    this.nodeDescription.get(new String[]{"children", element.getKey(), "model-description", element.getValue()}).set(value.get("result"));
                    continue;
                }
                if (!value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                break;
            }
            for (Map.Entry<Object, ModelNode> entry : this.operations.entrySet()) {
                this.nodeDescription.get(new String[]{"operations", (String)entry.getKey()}).set(entry.getValue());
            }
            context.getResult().set(this.nodeDescription);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    public static class ReadChildrenResourcesAssemblyHandler
    implements OperationStepHandler {
        private final Map<PathElement, ModelNode> resources;

        public ReadChildrenResourcesAssemblyHandler(Map<PathElement, ModelNode> resources) {
            this.resources = resources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    TreeMap<String, ModelNode> sortedChildren = new TreeMap<String, ModelNode>();
                    boolean failed = false;
                    for (Map.Entry entry : ReadChildrenResourcesAssemblyHandler.this.resources.entrySet()) {
                        PathElement path = (PathElement)entry.getKey();
                        ModelNode value = (ModelNode)entry.getValue();
                        if (!value.has("failure-description")) {
                            sortedChildren.put(path.getValue(), value.get("result"));
                            continue;
                        }
                        if (failed || !value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        failed = true;
                    }
                    if (!failed) {
                        ModelNode result = context.getResult();
                        result.setEmptyObject();
                        for (Map.Entry entry : sortedChildren.entrySet()) {
                            result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.VERIFY);
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    public static class ReadChildrenResourcesOperationHandler
    implements OperationStepHandler {
        private final ParametersValidator validator = new ParametersValidator();

        public ReadChildrenResourcesOperationHandler() {
            this.validator.registerValidator("child-type", new StringLengthValidator(1));
            this.validator.registerValidator("recursive", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("recursive-depth", new ModelTypeValidator(ModelType.INT, true));
            this.validator.registerValidator("include-runtime", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("proxies", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("include-defaults", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validate(operation);
            String childType = operation.require("child-type").asString();
            HashMap<PathElement, ModelNode> resources = new HashMap<PathElement, ModelNode>();
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            Map childAddresses = GlobalOperationHandlers.getChildAddresses(registry, resource, childType);
            Set childNames = (Set)childAddresses.get(childType);
            if (childNames == null) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownChildType(childType)));
            }
            ReadChildrenResourcesAssemblyHandler assemblyHandler = new ReadChildrenResourcesAssemblyHandler(resources);
            context.addStep(assemblyHandler, OperationContext.Stage.IMMEDIATE);
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            for (String key : childNames) {
                OperationStepHandler handler;
                PathElement childPath = PathElement.pathElement(childType, key);
                PathAddress childAddress = PathAddress.EMPTY_ADDRESS.append(PathElement.pathElement(childType, key));
                ModelNode readOp = new ModelNode();
                readOp.get("operation").set("read-resource");
                readOp.get("address").set(PathAddress.pathAddress(address, childPath).toModelNode());
                if (operation.hasDefined("include-runtime")) {
                    readOp.get("include-runtime").set(operation.get("include-runtime"));
                }
                if (operation.hasDefined("recursive")) {
                    readOp.get("recursive").set(operation.get("recursive"));
                }
                if (operation.hasDefined("recursive-depth")) {
                    readOp.get("recursive-depth").set(operation.get("recursive-depth"));
                }
                if (operation.hasDefined("proxies")) {
                    readOp.get("proxies").set(operation.get("proxies"));
                }
                if (operation.hasDefined("include-defaults")) {
                    readOp.get("include-defaults").set(operation.get("include-defaults"));
                }
                if ((handler = context.getResourceRegistration().getOperationHandler(childAddress, "read-resource")) == null) {
                    throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noOperationHandler()));
                }
                ModelNode rrRsp = new ModelNode();
                resources.put(childPath, rrRsp);
                context.addStep(rrRsp, readOp, handler, OperationContext.Stage.IMMEDIATE);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    public static class ReadChildrenNamesOperationHandler
    implements OperationStepHandler {
        private final ParametersValidator validator = new ParametersValidator();

        public ReadChildrenNamesOperationHandler() {
            this.validator.registerValidator("child-type", new StringLengthValidator(1));
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validate(operation);
            String childType = operation.require("child-type").asString();
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            Map childAddresses = GlobalOperationHandlers.getChildAddresses(registry, resource, childType);
            TreeSet childNames = (TreeSet)childAddresses.get(childType);
            if (childNames == null) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownChildType(childType)));
            }
            childNames = new TreeSet(childNames);
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String childName : childNames) {
                result.add(childName);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    public static class UndefineAttributeHandler
    extends WriteAttributeHandler {
        @Override
        public void execute(OperationContext context, ModelNode original) throws OperationFailedException {
            ModelNode operation = original.clone();
            operation.get("value").set(new ModelNode());
            super.execute(context, operation);
        }
    }

    public static class WriteAttributeHandler
    implements OperationStepHandler {
        private ParametersValidator nameValidator = new ParametersValidator();

        public WriteAttributeHandler() {
            this.nameValidator.registerValidator("name", new StringLengthValidator(1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.nameValidator.validate(operation);
            String attributeName = operation.require("name").asString();
            AttributeAccess attributeAccess = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (attributeAccess == null) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(attributeName)));
            }
            if (attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.attributeNotWritable(attributeName)));
            }
            OperationStepHandler handler = attributeAccess.getWriteHandler();
            ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(handler.getClass());
            try {
                handler.execute(context, operation);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldTccl);
            }
        }
    }

    public static class ReadAttributeHandler
    extends AbstractMultiTargetHandler
    implements OperationStepHandler {
        private ParametersValidator validator = new ParametersValidator();

        public ReadAttributeHandler() {
            this.validator.registerValidator("name", new StringLengthValidator(1));
            this.validator.registerValidator("include-defaults", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validate(operation);
            String attributeName = operation.require("name").asString();
            boolean defaults = operation.get("include-defaults").asBoolean(true);
            ModelNode subModel = GlobalOperationHandlers.safeReadModel(context);
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            AttributeAccess attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (attributeAccess == null) {
                Set<String> children = context.getResourceRegistration().getChildNames(PathAddress.EMPTY_ADDRESS);
                if (children.contains(attributeName)) {
                    throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.attributeRegisteredOnResource(attributeName, operation.get("address"))));
                }
                if (subModel.hasDefined(attributeName)) {
                    ModelNode result = subModel.get(attributeName);
                    context.getResult().set(result);
                } else {
                    ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                    if (defaults && nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get(new String[]{"attributes", attributeName}).hasDefined("default")) {
                        ModelNode result = nodeDescription.get(new String[]{"attributes", attributeName, "default"});
                        context.getResult().set(result);
                    } else if (subModel.has(attributeName) || nodeDescription.get("attributes").has(attributeName)) {
                        context.getResult();
                    } else {
                        throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(attributeName)));
                    }
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            } else if (attributeAccess.getReadHandler() == null) {
                if (subModel.hasDefined(attributeName) || !defaults) {
                    ModelNode result = subModel.get(attributeName);
                    context.getResult().set(result);
                } else {
                    ModelNode nodeDescription = this.getNodeDescription(registry, context, operation);
                    if (nodeDescription.get("attributes").hasDefined(attributeName) && nodeDescription.get(new String[]{"attributes", attributeName}).hasDefined("default")) {
                        ModelNode result = nodeDescription.get(new String[]{"attributes", attributeName, "default"});
                        context.getResult().set(result);
                    } else {
                        context.getResult();
                    }
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            } else {
                OperationStepHandler handler = attributeAccess.getReadHandler();
                ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(handler.getClass());
                try {
                    handler.execute(context, operation);
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(oldTccl);
                }
            }
        }

        private ModelNode getNodeDescription(ImmutableManagementResourceRegistration registry, OperationContext context, ModelNode operation) throws OperationFailedException {
            DescriptionProvider descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS);
            Locale locale = GlobalOperationHandlers.getLocale(context, operation);
            return descriptionProvider.getModelDescription(locale);
        }
    }

    private static class ReadResourceAssemblyHandler
    implements OperationStepHandler {
        private final Map<String, ModelNode> directAttributes;
        private final Map<String, ModelNode> directChildren;
        private final Map<String, ModelNode> metrics;
        private final Map<String, ModelNode> otherAttributes;
        private final Map<PathElement, ModelNode> childResources;

        private ReadResourceAssemblyHandler(Map<String, ModelNode> directAttributes, Map<String, ModelNode> metrics, Map<String, ModelNode> otherAttributes, Map<String, ModelNode> directChildren, Map<PathElement, ModelNode> childResources) {
            this.directAttributes = directAttributes;
            this.metrics = metrics;
            this.otherAttributes = otherAttributes;
            this.directChildren = directChildren;
            this.childResources = childResources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value;
            TreeMap<Object, ModelNode> sortedAttributes = new TreeMap<Object, ModelNode>();
            TreeMap<Object, ModelNode> sortedChildren = new TreeMap<Object, ModelNode>();
            boolean failed = false;
            for (Map.Entry<String, ModelNode> entry : this.otherAttributes.entrySet()) {
                value = entry.getValue();
                if (!value.has("failure-description")) {
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                    continue;
                }
                if (failed || !value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                failed = true;
                break;
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.childResources.entrySet()) {
                    PathElement path = (PathElement)entry.getKey();
                    ModelNode value2 = entry.getValue();
                    if (!value2.has("failure-description")) {
                        ModelNode childTypeNode = (ModelNode)sortedChildren.get(path.getKey());
                        if (childTypeNode == null) {
                            childTypeNode = new ModelNode();
                            sortedChildren.put(path.getKey(), childTypeNode);
                        }
                        childTypeNode.get(path.getValue()).set(value2.get("result"));
                        continue;
                    }
                    if (failed || !value2.hasDefined("failure-description")) continue;
                    context.getFailureDescription().set(value2.get("failure-description"));
                    failed = true;
                }
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.directAttributes.entrySet()) {
                    sortedAttributes.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Object, ModelNode> entry : this.directChildren.entrySet()) {
                    sortedChildren.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Object, ModelNode> entry : this.metrics.entrySet()) {
                    value = entry.getValue();
                    if (value.has("failure-description")) continue;
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                }
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : sortedAttributes.entrySet()) {
                    result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                }
                for (Map.Entry entry : sortedChildren.entrySet()) {
                    result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                }
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }

    public static class ReadResourceHandler
    extends AbstractMultiTargetHandler
    implements OperationStepHandler {
        private final ParametersValidator validator = new ParametersValidator();

        public ReadResourceHandler() {
            this.validator.registerValidator("recursive", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("recursive-depth", new ModelTypeValidator(ModelType.INT, true));
            this.validator.registerValidator("include-runtime", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("proxies", new ModelTypeValidator(ModelType.BOOLEAN, true));
            this.validator.registerValidator("include-defaults", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }

        @Override
        public void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.validator.validate(operation);
            String opName = operation.require("operation").asString();
            ModelNode opAddr = operation.get("address");
            PathAddress address = PathAddress.pathAddress(opAddr);
            int recursiveDepth = operation.get("recursive-depth").asInt(0);
            boolean recursive = recursiveDepth > 0 ? true : operation.get("recursive").asBoolean(false);
            boolean queryRuntime = operation.get("include-runtime").asBoolean(false);
            boolean proxies = operation.get("proxies").asBoolean(false);
            boolean defaults = operation.get("include-defaults").asBoolean(true);
            HashMap<String, ModelNode> directAttributes = new HashMap<String, ModelNode>();
            HashMap<String, ModelNode> directChildren = new HashMap<String, ModelNode>();
            HashMap<String, ModelNode> metrics = queryRuntime ? new HashMap<String, ModelNode>() : Collections.emptyMap();
            HashMap<String, ModelNode> otherAttributes = new HashMap<String, ModelNode>();
            LinkedHashMap<PathElement, ModelNode> childResources = recursive ? new LinkedHashMap<PathElement, ModelNode>() : Collections.emptyMap();
            ReadResourceAssemblyHandler assemblyHandler = new ReadResourceAssemblyHandler(directAttributes, metrics, otherAttributes, directChildren, childResources);
            context.addStep(assemblyHandler, queryRuntime ? OperationContext.Stage.VERIFY : OperationContext.Stage.IMMEDIATE, queryRuntime);
            ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
            Resource resource = ReadResourceHandler.nullSafeReadResource(context, registry);
            Map childrenByType = registry != null ? GlobalOperationHandlers.getChildAddresses(registry, resource, null) : Collections.emptyMap();
            ModelNode model = resource.getModel();
            if (model.isDefined()) {
                Locale locale;
                DescriptionProvider descriptionProvider;
                ModelNode nodeDescription;
                for (String string : model.keys()) {
                    if (childrenByType.containsKey(string)) continue;
                    directAttributes.put(string, model.get(string));
                }
                if (defaults && (nodeDescription = (descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS)).getModelDescription(locale = GlobalOperationHandlers.getLocale(context, operation))).isDefined() && nodeDescription.hasDefined("attributes")) {
                    for (String key : nodeDescription.get("attributes").keys()) {
                        if (childrenByType.containsKey(key) || directAttributes.containsKey(key) && ((ModelNode)directAttributes.get(key)).isDefined() || !nodeDescription.get("attributes").hasDefined(key) || !nodeDescription.get(new String[]{"attributes", key}).hasDefined("default")) continue;
                        directAttributes.put(key, nodeDescription.get(new String[]{"attributes", key, "default"}));
                    }
                }
            }
            for (Map.Entry entry : childrenByType.entrySet()) {
                String childType = (String)entry.getKey();
                Set children = (Set)entry.getValue();
                if (children.isEmpty()) {
                    directAttributes.put(childType, new ModelNode());
                    continue;
                }
                for (String child : children) {
                    boolean storeDirect;
                    boolean bl = storeDirect = !recursive;
                    if (recursive) {
                        PathElement childPE = PathElement.pathElement(childType, child);
                        PathAddress relativeAddr = PathAddress.pathAddress(childPE);
                        ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                        if (childReg == null) {
                            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noChildRegistry(childType, child)));
                        }
                        boolean proxy = childReg.isRemote();
                        boolean runtimeResource = childReg.isRuntimeOnly();
                        if (!runtimeResource || queryRuntime && !proxy || proxies && proxy) {
                            int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                            ModelNode rrOp = new ModelNode();
                            rrOp.get("operation").set(opName);
                            rrOp.get("address").set(PathAddress.pathAddress(address, childPE).toModelNode());
                            rrOp.get("recursive").set(operation.get("recursive"));
                            rrOp.get("recursive-depth").set(newDepth);
                            rrOp.get("proxies").set(proxies);
                            rrOp.get("include-runtime").set(queryRuntime);
                            ModelNode rrRsp = new ModelNode();
                            childResources.put(childPE, rrRsp);
                            OperationStepHandler rrHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
                            context.addStep(rrRsp, rrOp, rrHandler, OperationContext.Stage.IMMEDIATE);
                        } else {
                            storeDirect = true;
                        }
                    }
                    if (!storeDirect) continue;
                    ModelNode childMap = (ModelNode)directChildren.get(childType);
                    if (childMap == null) {
                        childMap = new ModelNode();
                        childMap.setEmptyObject();
                        directChildren.put(childType, childMap);
                    }
                    childMap.get(child);
                }
            }
            Set<String> attributeNames = registry != null ? registry.getAttributeNames(PathAddress.EMPTY_ADDRESS) : Collections.emptySet();
            for (String attributeName : attributeNames) {
                AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
                if (access == null) continue;
                AttributeAccess.Storage storage = access.getStorageType();
                if (!queryRuntime && storage != AttributeAccess.Storage.CONFIGURATION) continue;
                AttributeAccess.AccessType type = access.getAccessType();
                OperationStepHandler handler = access.getReadHandler();
                if (handler == null) continue;
                directAttributes.remove(attributeName);
                ModelNode attributeOperation = new ModelNode();
                attributeOperation.get("address").set(opAddr);
                attributeOperation.get("operation").set("read-attribute");
                attributeOperation.get("name").set(attributeName);
                ModelNode attrResponse = new ModelNode();
                if (type == AttributeAccess.AccessType.METRIC) {
                    metrics.put(attributeName, attrResponse);
                } else {
                    otherAttributes.put(attributeName, attrResponse);
                }
                context.addStep(attrResponse, attributeOperation, handler, OperationContext.Stage.IMMEDIATE);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }

        private static Resource nullSafeReadResource(OperationContext context, ImmutableManagementResourceRegistration registry) {
            Resource result;
            if (registry != null && registry.isRuntimeOnly()) {
                try {
                    result = context.readResource(PathAddress.EMPTY_ADDRESS, false);
                }
                catch (RuntimeException e) {
                    result = PlaceholderResource.INSTANCE;
                }
            } else {
                result = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            }
            return result;
        }
    }
}

