/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import org.jboss.arquillian.test.spi.ArquillianProxyException;
import org.jboss.arquillian.test.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionProxy
implements Externalizable {
    private static final long serialVersionUID = 2321010311438950147L;
    private String className;
    private String message;
    private StackTraceElement[] trace;
    private ExceptionProxy causeProxy;
    private Throwable cause;
    private Throwable original;

    public ExceptionProxy() {
    }

    public ExceptionProxy(Throwable throwable) {
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.trace = throwable.getStackTrace();
        this.causeProxy = ExceptionProxy.createForException(throwable.getCause());
        this.original = throwable;
    }

    public boolean hasException() {
        return this.className != null;
    }

    public Throwable createException() {
        if (!this.hasException()) {
            return null;
        }
        if (this.original != null) {
            return this.original;
        }
        ArquillianProxyException throwable = this.createProxyException("Original exception not deserilizable, ClassNotFoundException");
        throwable.setStackTrace(this.trace);
        return throwable;
    }

    public ArquillianProxyException createProxyException(String reason) {
        ArquillianProxyException exception = new ArquillianProxyException(this.message, this.className, reason, this.getCause());
        exception.setStackTrace(this.trace);
        return exception;
    }

    private Throwable constructExceptionForClass(Class<?> clazz) {
        Object object = this.buildObjectFromClassConstructors(clazz);
        if (object == null) {
            return this.createProxyException("Could not find suitable constructor");
        }
        if (!(object instanceof Throwable)) {
            return this.createProxyException("Proxy references non-Throwable type");
        }
        return (Throwable)object;
    }

    private Object buildObjectFromClassConstructors(Class<?> clazz) {
        Object object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class, Throwable.class}, new Object[]{this.message, this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class, Exception.class}, new Object[]{this.message, this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{Throwable.class}, new Object[]{this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{Exception.class}, new Object[]{this.getCause()});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{Object.class}, new Object[]{this.message});
        if (object != null) {
            return object;
        }
        object = this.buildExceptionFromConstructor(clazz, new Class[]{String.class}, new Object[]{this.message});
        if (object != null) {
            return object;
        }
        return null;
    }

    private <T> T buildExceptionFromConstructor(Class<T> clazz, Class<?>[] signature, Object[] params) {
        Constructor<T> constructor = null;
        Class<T> nextSource = clazz;
        try {
            constructor = nextSource.getDeclaredConstructor(signature);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                T result = constructor.newInstance(params);
                return result;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static ExceptionProxy createForException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return new ExceptionProxy(throwable);
    }

    public Throwable getCause() {
        if (this.cause == null && this.causeProxy != null) {
            this.cause = this.causeProxy.createException();
        }
        return this.cause;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.message = (String)in.readObject();
        this.trace = (StackTraceElement[])in.readObject();
        this.causeProxy = (ExceptionProxy)in.readObject();
        byte[] originalExceptionData = (byte[])in.readObject();
        if (originalExceptionData != null && originalExceptionData.length > 0) {
            try {
                ByteArrayInputStream originalIn = new ByteArrayInputStream(originalExceptionData);
                ObjectInputStream input = new ObjectInputStream(originalIn);
                this.original = (Throwable)input.readObject();
                try {
                    SecurityActions.setFieldValue(Throwable.class, this.original, "cause", this.causeProxy.createException());
                }
                catch (Exception e) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.message);
        out.writeObject(this.trace);
        out.writeObject(this.causeProxy);
        byte[] originalBytes = new byte[]{};
        if (this.original != null) {
            try {
                SecurityActions.setFieldValue(Throwable.class, this.original, "cause", null);
            }
            catch (Exception e) {
                // empty catch block
            }
            ByteArrayOutputStream originalOut = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(originalOut);
            output.writeObject(this.original);
            output.flush();
            originalBytes = originalOut.toByteArray();
        }
        out.writeObject(originalBytes);
    }

    public String toString() {
        return super.toString() + String.format("[class=%s, message=%s],cause = %s", this.className, this.message, this.causeProxy);
    }
}

