/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAnd;
import org.jboss.aop.pointcut.ast.ASTAndCFlow;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTComposite;
import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
import org.jboss.aop.pointcut.ast.ASTConstruction;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTExecution;
import org.jboss.aop.pointcut.ast.ASTExecutionOnly;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTFieldExecution;
import org.jboss.aop.pointcut.ast.ASTGet;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNot;
import org.jboss.aop.pointcut.ast.ASTNotCFlow;
import org.jboss.aop.pointcut.ast.ASTOr;
import org.jboss.aop.pointcut.ast.ASTOrCFlow;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTPointcut;
import org.jboss.aop.pointcut.ast.ASTSet;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSub;
import org.jboss.aop.pointcut.ast.ASTSubCFlow;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
import org.jboss.aop.pointcut.ast.SimpleNode;

public class PointcutStats
implements PointcutExpressionParserVisitor {
    protected ASTStart start;
    protected AspectManager manager;
    protected boolean execution = false;
    protected boolean methodExecution = false;
    protected boolean constructorExecution = false;
    protected boolean construction = false;
    protected boolean call = false;
    protected boolean methodCall = false;
    protected boolean constructorCall = false;
    protected boolean within = false;
    protected boolean get = false;
    protected boolean set = false;
    protected boolean withincode = false;

    public PointcutStats(ASTStart start, AspectManager manager) {
        this.start = start;
        this.manager = manager;
    }

    public boolean isExecution() {
        return this.execution;
    }

    public boolean isMethodExecution() {
        return this.methodExecution;
    }

    public boolean isConstructorExecution() {
        return this.constructorExecution;
    }

    public boolean isConstruction() {
        return this.construction;
    }

    public boolean isCall() {
        return this.call;
    }

    public boolean isMethodCall() {
        return this.methodCall;
    }

    public boolean isConstructorCall() {
        return this.constructorCall;
    }

    public boolean isWithin() {
        return this.within;
    }

    public boolean isGet() {
        return this.get;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isWithincode() {
        return this.withincode;
    }

    public boolean matches() {
        return (Boolean)this.visit(this.start, null);
    }

    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTExecutionOnly node, Object data) {
        throw new RuntimeException("SHOULD NEVER BE CALLED!");
    }

    public Object visit(ASTBoolean node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTComposite node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTNot node, Object data) {
        Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        boolean val = bool;
        return val ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTSub node, Object data) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            data = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return data;
    }

    public Object visit(ASTAnd node, Object left) {
        Node andChild = node.jjtGetChild(0);
        andChild.jjtAccept(this, (Object)Boolean.FALSE);
        return Boolean.FALSE;
    }

    public Object visit(ASTOr node, Object left) {
        Node orChild = node.jjtGetChild(0);
        orChild.jjtAccept(this, (Object)Boolean.FALSE);
        return Boolean.FALSE;
    }

    private void setAllTrue() {
        this.execution = true;
        this.methodExecution = true;
        this.constructorExecution = true;
        this.call = true;
        this.methodCall = true;
        this.constructorCall = true;
        this.within = true;
        this.get = true;
        this.set = true;
        this.withincode = true;
    }

    public Object visit(ASTPointcut node, Object data) {
        Pointcut p;
        if (this.manager == null) {
            this.setAllTrue();
        }
        if ((p = this.manager.getPointcut(node.getPointcutName())) instanceof PointcutExpression) {
            PointcutExpression expr = (PointcutExpression)p;
            PointcutStats stats = expr.getStats();
            if (stats != null) {
                this.execution |= stats.isExecution();
                this.methodExecution |= stats.isMethodExecution();
                this.constructorExecution |= stats.isConstructorExecution();
                this.call |= stats.isCall();
                this.methodCall |= stats.isMethodCall();
                this.constructorCall |= stats.isConstructorCall();
                this.within |= stats.isWithin();
                this.get |= stats.isGet();
                this.set |= stats.isSet();
                this.withincode |= stats.isWithincode();
            } else {
                this.setAllTrue();
            }
        } else {
            this.setAllTrue();
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTAll node, Object data) {
        this.execution = true;
        this.get = true;
        this.set = true;
        this.methodExecution = true;
        this.constructorExecution = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTCFlowExpression node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTCall node, Object data) {
        this.call = true;
        node.getBehavior().jjtAccept(this, (Object)node);
        return Boolean.FALSE;
    }

    public Object visit(ASTWithin node, Object data) {
        this.within = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTWithincode node, Object data) {
        this.withincode = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTExecution node, Object data) {
        this.execution = true;
        node.childrenAccept(this, (Object)node);
        return Boolean.FALSE;
    }

    public Object visit(ASTConstruction node, Object data) {
        this.construction = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTConstructor node, Object data) {
        Object parent = data;
        if (parent instanceof ASTExecution) {
            this.constructorExecution = true;
            this.execution = true;
        } else if (parent instanceof ASTCall) {
            this.constructorCall = true;
            this.call = true;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTMethod node, Object data) {
        Object parent = data;
        if (parent instanceof ASTExecution) {
            this.methodExecution = true;
            this.execution = true;
        } else if (parent instanceof ASTCall) {
            this.methodCall = true;
            this.call = true;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTParameter node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTGet node, Object data) {
        this.get = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTSet node, Object data) {
        this.set = true;
        return Boolean.FALSE;
    }

    public Object visit(ASTFieldExecution node, Object data) {
        this.set = true;
        this.get = true;
        return Boolean.FALSE;
    }

    public Object visit(SimpleNode node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTCFlowBoolean node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTNotCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTCompositeCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTSubCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAndCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTOrCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTCFlow node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAttribute node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTAllParameter node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTField node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTException node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTHas node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTHasField node, Object data) {
        return Boolean.FALSE;
    }
}

