/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodExecution;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends JoinPointInfo
implements MethodExecution {
    private Method advisedMethod;
    public Method unadvisedMethod;
    private long hash;

    public MethodInfo() {
    }

    public MethodInfo(Class<?> clazz, long hash, long unadvisedHash, Advisor advisor) {
        super(advisor, clazz);
        try {
            this.hash = hash;
            this.advisedMethod = MethodHashing.findMethodByHash(clazz, hash);
            this.unadvisedMethod = MethodHashing.findMethodByHash(clazz, unadvisedHash);
            this.setAdvisor(advisor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MethodInfo(MethodInfo other) {
        super(other);
        this.advisedMethod = other.advisedMethod;
        this.unadvisedMethod = other.unadvisedMethod;
        this.hash = other.hash;
    }

    @Override
    protected Joinpoint internalGetJoinpoint() {
        return new MethodJoinpoint(this.advisedMethod);
    }

    @Override
    public JoinPointInfo copy() {
        return new MethodInfo(this);
    }

    @Deprecated
    public Method getAdvisedMethod() {
        return this.advisedMethod;
    }

    @Override
    public Method getMethod() {
        return this.advisedMethod;
    }

    public void setAdvisedMethod(Method advisedMethod) {
        this.advisedMethod = advisedMethod;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }

    public Method getUnadvisedMethod() {
        return this.unadvisedMethod;
    }

    public void setUnadvisedMethod(Method unadvisedMethod) {
        this.unadvisedMethod = unadvisedMethod;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method");
        sb.append("[");
        sb.append("method=" + this.advisedMethod);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public <T extends Annotation> T resolveAnnotation(Class<T> annotation) {
        T val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        Advisor advisor = this.getAdvisor();
        if (advisor != null) {
            return this.getAdvisor().resolveTypedAnnotation(this.hash, this.advisedMethod, annotation);
        }
        return null;
    }
}

