/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.Channel;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.security.ElytronUsernamePasswordAuthenticator;
import org.infinispan.server.security.RespClientCertAuthenticator;
import org.infinispan.util.concurrent.BlockingManager;

public class ElytronRESPAuthenticator
implements RespAuthenticator {
    private UsernamePasswordAuthenticator usernamePasswordAuthenticator;
    private RespClientCertAuthenticator clientCertAuthenticator;

    public CompletionStage<Subject> clientCertAuth(Channel channel) throws SaslException {
        if (this.clientCertAuthenticator == null) {
            Server.log.debug("No usernamePasswordAuthenticator configured for RESP");
            return CompletableFutures.completedNull();
        }
        return this.clientCertAuthenticator.clientCertAuth(channel);
    }

    public CompletionStage<Subject> usernamePasswordAuth(String username, char[] password) {
        if (this.usernamePasswordAuthenticator == null) {
            Server.log.debug("No usernamePasswordAuthenticator configured for RESP");
            return CompletableFutures.completedNull();
        }
        return this.usernamePasswordAuthenticator.authenticate(username, password);
    }

    public boolean isClientCertAuthEnabled() {
        return this.clientCertAuthenticator != null;
    }

    public void withUsernamePasswordAuth(UsernamePasswordAuthenticator usernamePasswordAuthenticator) {
        this.usernamePasswordAuthenticator = usernamePasswordAuthenticator;
    }

    public void withClientCertAuth(RespClientCertAuthenticator clientCertAuthenticator) {
        this.clientCertAuthenticator = clientCertAuthenticator;
    }

    void init(ServerConfiguration configuration, BlockingManager blockingManager) {
        if (this.usernamePasswordAuthenticator != null) {
            ElytronUsernamePasswordAuthenticator.init(this.usernamePasswordAuthenticator, configuration, blockingManager);
        }
    }

    void init(ServerConfiguration configuration, ScheduledExecutorService timeoutExecutor) {
        if (this.clientCertAuthenticator != null) {
            this.clientCertAuthenticator.init(configuration, timeoutExecutor);
        }
    }
}

