/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.util.EnumSet;
import java.util.Properties;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.GroupsPropertiesConfiguration;
import org.infinispan.server.configuration.security.PropertiesRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.UserPropertiesConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.server.security.realm.PropertiesSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;

@BuiltBy(value=PropertiesRealmConfigurationBuilder.class)
public class PropertiesRealmConfiguration
extends ConfigurationElement<PropertiesRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"properties", String.class).immutable().build();
    static final AttributeDefinition<String> GROUPS_ATTRIBUTE = AttributeDefinition.builder((Enum)Attribute.GROUPS_ATTRIBUTE, (Object)"Roles", String.class).build();
    private final UserPropertiesConfiguration userPropertiesConfiguration;
    private final GroupsPropertiesConfiguration groupsPropertiesConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PropertiesRealmConfiguration.class, new AttributeDefinition[]{NAME, GROUPS_ATTRIBUTE});
    }

    PropertiesRealmConfiguration(AttributeSet attributes, UserPropertiesConfiguration userPropertiesConfiguration, GroupsPropertiesConfiguration groupsPropertiesConfiguration) {
        super((Enum)Element.PROPERTIES_REALM, attributes, new ConfigurationElement[]{userPropertiesConfiguration, groupsPropertiesConfiguration});
        this.userPropertiesConfiguration = userPropertiesConfiguration;
        this.groupsPropertiesConfiguration = groupsPropertiesConfiguration;
    }

    public UserPropertiesConfiguration userProperties() {
        return this.userPropertiesConfiguration;
    }

    public GroupsPropertiesConfiguration groupProperties() {
        return this.groupsPropertiesConfiguration;
    }

    @Override
    public SecurityRealm build(SecurityConfiguration securityConfiguration, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        File usersFile = this.userPropertiesConfiguration.getFile(properties);
        File groupsFile = this.groupsPropertiesConfiguration.getFile(properties);
        String groupsAttribute = (String)this.attributes.attribute(GROUPS_ATTRIBUTE).get();
        boolean plainText = this.userPropertiesConfiguration.plainText();
        String realmName = this.userPropertiesConfiguration.digestRealmName();
        PropertiesSecurityRealm propertiesSecurityRealm = new PropertiesSecurityRealm(usersFile, groupsFile, plainText, groupsAttribute, realmName);
        realm.setHttpChallengeReadiness(() -> !propertiesSecurityRealm.isEmpty());
        return propertiesSecurityRealm;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    @Override
    public void applyFeatures(EnumSet<ServerSecurityRealm.Feature> features) {
        features.add(ServerSecurityRealm.Feature.PASSWORD_PLAIN);
        features.add(ServerSecurityRealm.Feature.PASSWORD_HASHED);
    }
}

