/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private final Map<String, Set<String>> serviceEntries = new LinkedHashMap<String, Set<String>>();

    @Override
    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Set<String> serviceLines = this.getServiceLines(resource);
        for (String line : this.readAllLines(is)) {
            if (line.isEmpty()) continue;
            serviceLines.add(this.relocateIfPossible(relocators, line));
        }
        is.close();
    }

    private Set<String> getServiceLines(String resource) {
        Set<String> lines = this.serviceEntries.get(resource);
        if (lines == null) {
            lines = new LinkedHashSet<String>();
            this.serviceEntries.put(resource, lines);
        }
        return lines;
    }

    private String[] readAllLines(InputStream is) throws IOException {
        return IOUtil.toString((InputStream)is, (String)"utf-8").replace('\r', '|').replace('\n', '|').split("\\|");
    }

    private String relocateIfPossible(List<Relocator> relocators, String line) {
        for (Relocator relocator : relocators) {
            if (!relocator.canRelocateClass(line)) continue;
            return relocator.relocateClass(line);
        }
        return line;
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.serviceEntries.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, Set<String>> entry : this.serviceEntries.entrySet()) {
            jos.putNextEntry(new JarEntry(entry.getKey()));
            jos.write(this.toResourceBytes(entry.getValue()));
        }
    }

    private byte[] toResourceBytes(Set<String> value) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String line : value) {
            builder.append(line).append('\n');
        }
        return builder.toString().getBytes("utf-8");
    }
}

