/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.MinijarFilter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.apache.maven.plugins.shade.mojo.ArtifactSelector;
import org.apache.maven.plugins.shade.mojo.ArtifactSet;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.mojo.RelativizePath;
import org.apache.maven.plugins.shade.pom.PomWriter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="shade", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ShadeMojo
extends AbstractMojo
implements Contextualizable {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(hint="default", role=Shader.class)
    private Shader shader;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter
    private ArtifactSet artifactSet;
    @Parameter
    private PackageRelocation[] relocations;
    @Parameter
    private ResourceTransformer[] transformers;
    @Parameter
    private ArchiveFilter[] filters;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private String finalName;
    @Parameter(defaultValue="${project.artifactId}")
    private String shadedArtifactId;
    @Parameter
    private String shadedGroupFilter;
    @Parameter
    private boolean shadedArtifactAttached;
    @Parameter(defaultValue="true")
    private boolean createDependencyReducedPom;
    @Parameter(defaultValue="${basedir}/dependency-reduced-pom.xml")
    private File dependencyReducedPomLocation;
    @Parameter(defaultValue="false")
    private boolean generateUniqueDependencyReducedPom;
    @Parameter
    private boolean keepDependenciesWithProvidedScope;
    @Parameter
    private boolean promoteTransitiveDependencies;
    @Parameter(defaultValue="shaded")
    private String shadedClassifierName;
    @Parameter
    private boolean createSourcesJar;
    @Parameter(property="shadeSourcesContent", defaultValue="false")
    private boolean shadeSourcesContent;
    @Parameter
    private boolean minimizeJar;
    @Parameter
    private File outputFile;
    @Parameter
    private String shaderHint;
    @Parameter(defaultValue="false")
    private boolean useBaseVersion;
    @Parameter(defaultValue="false")
    private boolean shadeTestJar;
    private PlexusContainer plexusContainer;

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException {
        this.setupHintedShader();
        LinkedHashSet<File> artifacts = new LinkedHashSet<File>();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        LinkedHashSet<File> sourceArtifacts = new LinkedHashSet<File>();
        LinkedHashSet<File> testArtifacts = new LinkedHashSet<File>();
        ArtifactSelector artifactSelector = new ArtifactSelector(this.project.getArtifact(), this.artifactSet, this.shadedGroupFilter);
        if (artifactSelector.isSelected(this.project.getArtifact()) && !"pom".equals(this.project.getArtifact().getType())) {
            File file;
            if (this.invalidMainArtifact()) {
                this.getLog().error((CharSequence)"The project main artifact does not exist. This could have the following");
                this.getLog().error((CharSequence)"reasons:");
                this.getLog().error((CharSequence)"- You have invoked the goal directly from the command line. This is not");
                this.getLog().error((CharSequence)"  supported. Please add the goal to the default lifecycle via an");
                this.getLog().error((CharSequence)"  <execution> element in your POM and use \"mvn package\" to have it run.");
                this.getLog().error((CharSequence)"- You have bound the goal to a lifecycle phase before \"package\". Please");
                this.getLog().error((CharSequence)"  remove this binding from your POM such that the goal will be run in");
                this.getLog().error((CharSequence)"  the proper phase.");
                this.getLog().error((CharSequence)"- You removed the configuration of the maven-jar-plugin that produces the main artifact.");
                throw new MojoExecutionException("Failed to create shaded artifact, project main artifact does not exist.");
            }
            artifacts.add(this.project.getArtifact().getFile());
            if (this.createSourcesJar && (file = this.shadedSourcesArtifactFile()).isFile()) {
                sourceArtifacts.add(file);
            }
            if (this.shadeTestJar && (file = this.shadedTestArtifactFile()).isFile()) {
                testArtifacts.add(file);
            }
        }
        this.processArtifactSelectors(artifacts, artifactIds, sourceArtifacts, artifactSelector);
        File outputJar = this.outputFile != null ? this.outputFile : this.shadedArtifactFileWithClassifier();
        File sourcesJar = this.shadedSourceArtifactFileWithClassifier();
        File testJar = this.shadedTestArtifactFileWithClassifier();
        try {
            ShadeRequest shadeSourcesRequest;
            List<Filter> filters = this.getFilters();
            List<Relocator> relocators = this.getRelocators();
            List<ResourceTransformer> resourceTransformers = this.getResourceTransformers();
            ShadeRequest shadeRequest = new ShadeRequest();
            shadeRequest.setJars(artifacts);
            shadeRequest.setUberJar(outputJar);
            shadeRequest.setFilters(filters);
            shadeRequest.setRelocators(relocators);
            shadeRequest.setResourceTransformers(resourceTransformers);
            this.shader.shade(shadeRequest);
            if (this.createSourcesJar) {
                shadeSourcesRequest = new ShadeRequest();
                shadeSourcesRequest.setJars(sourceArtifacts);
                shadeSourcesRequest.setUberJar(sourcesJar);
                shadeSourcesRequest.setFilters(filters);
                shadeSourcesRequest.setRelocators(relocators);
                shadeSourcesRequest.setResourceTransformers(resourceTransformers);
                shadeSourcesRequest.setShadeSourcesContent(this.shadeSourcesContent);
                this.shader.shade(shadeSourcesRequest);
            }
            if (this.shadeTestJar) {
                shadeSourcesRequest = new ShadeRequest();
                shadeSourcesRequest.setJars(testArtifacts);
                shadeSourcesRequest.setUberJar(testJar);
                shadeSourcesRequest.setFilters(filters);
                shadeSourcesRequest.setRelocators(relocators);
                shadeSourcesRequest.setResourceTransformers(resourceTransformers);
                shadeSourcesRequest.setShadeSourcesContent(this.shadeSourcesContent);
                this.shader.shade(shadeSourcesRequest);
            }
            if (this.outputFile == null) {
                boolean renamed = false;
                if (this.finalName != null && this.finalName.length() > 0 && !this.finalName.equals(this.project.getBuild().getFinalName())) {
                    String finalFileName = this.finalName + "." + this.project.getArtifact().getArtifactHandler().getExtension();
                    File finalFile = new File(this.outputDirectory, finalFileName);
                    this.replaceFile(finalFile, outputJar);
                    outputJar = finalFile;
                    renamed = true;
                }
                if (this.shadedArtifactAttached) {
                    this.getLog().info((CharSequence)"Attaching shaded artifact.");
                    this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.shadedClassifierName, outputJar);
                    if (this.createSourcesJar) {
                        this.projectHelper.attachArtifact(this.project, "jar", this.shadedClassifierName + "-sources", sourcesJar);
                    }
                } else if (!renamed) {
                    this.getLog().info((CharSequence)"Replacing original artifact with shaded artifact.");
                    File originalArtifact = this.project.getArtifact().getFile();
                    if (originalArtifact != null) {
                        this.replaceFile(originalArtifact, outputJar);
                        if (this.createSourcesJar) {
                            this.getLog().info((CharSequence)"Replacing original source artifact with shaded source artifact.");
                            File shadedSources = this.shadedSourcesArtifactFile();
                            this.replaceFile(shadedSources, sourcesJar);
                            this.projectHelper.attachArtifact(this.project, "jar", "sources", shadedSources);
                        }
                        if (this.shadeTestJar) {
                            this.getLog().info((CharSequence)"Replacing original test artifact with shaded test artifact.");
                            File shadedTests = this.shadedTestArtifactFile();
                            this.replaceFile(shadedTests, testJar);
                            this.projectHelper.attachArtifact(this.project, "jar", "tests", shadedTests);
                        }
                        if (this.createDependencyReducedPom) {
                            this.createDependencyReducedPom(artifactIds);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating shaded jar: " + e.getMessage(), e);
        }
    }

    private void setupHintedShader() throws MojoExecutionException {
        if (this.shaderHint != null) {
            try {
                this.shader = (Shader)this.plexusContainer.lookup(Shader.ROLE, this.shaderHint);
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("unable to lookup own Shader implementation with hint:'" + this.shaderHint + "'", (Exception)((Object)e));
            }
        }
    }

    private void processArtifactSelectors(Set<File> artifacts, Set<String> artifactIds, Set<File> sourceArtifacts, ArtifactSelector artifactSelector) {
        for (Artifact artifact : this.project.getArtifacts()) {
            File file;
            if (!artifactSelector.isSelected(artifact)) {
                this.getLog().info((CharSequence)("Excluding " + artifact.getId() + " from the shaded jar."));
                continue;
            }
            if ("pom".equals(artifact.getType())) {
                this.getLog().info((CharSequence)("Skipping pom dependency " + artifact.getId() + " in the shaded jar."));
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the shaded jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
            if (!this.createSourcesJar || (file = this.resolveArtifactSources(artifact)) == null) continue;
            sourceArtifacts.add(file);
        }
    }

    private boolean invalidMainArtifact() {
        return this.project.getArtifact().getFile() == null || !this.project.getArtifact().getFile().isFile();
    }

    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    this.copyFiles(oldFile, origFile);
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    this.copyFiles(newFile, oldFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with shaded artifact!", (Exception)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles(File source, File target) throws IOException {
        FileOutputStream fout = new FileOutputStream(target);
        FileInputStream fin = new FileInputStream(source);
        try {
            IOUtil.copy((InputStream)fin, (OutputStream)fout);
        }
        finally {
            IOUtil.close((InputStream)fin);
            IOUtil.close((OutputStream)fout);
        }
    }

    private File resolveArtifactSources(Artifact artifact) {
        Artifact resolvedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
        try {
            this.artifactResolver.resolve(resolvedArtifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Could not get sources for " + artifact));
        }
        if (resolvedArtifact.isResolved()) {
            return resolvedArtifact.getFile();
        }
        return null;
    }

    private List<Relocator> getRelocators() {
        ArrayList<Relocator> relocators = new ArrayList<Relocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (PackageRelocation r : this.relocations) {
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getIncludes(), r.getExcludes(), r.isRawString()));
        }
        return relocators;
    }

    private List<ResourceTransformer> getResourceTransformers() {
        if (this.transformers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.transformers);
    }

    private List<Filter> getFilters() throws MojoExecutionException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<SimpleFilter> simpleFilters = new ArrayList<SimpleFilter>();
        if (this.filters != null && this.filters.length > 0) {
            HashMap<Artifact, ArtifactId> artifacts = new HashMap<Artifact, ArtifactId>();
            artifacts.put(this.project.getArtifact(), new ArtifactId(this.project.getArtifact()));
            for (Artifact artifact : this.project.getArtifacts()) {
                artifacts.put(artifact, new ArtifactId(artifact));
            }
            for (ArchiveFilter filter : this.filters) {
                ArtifactId pattern = new ArtifactId(filter.getArtifact());
                HashSet<File> jars = new HashSet<File>();
                for (Map.Entry entry : artifacts.entrySet()) {
                    File file;
                    if (!((ArtifactId)entry.getValue()).matches(pattern)) continue;
                    Artifact artifact = (Artifact)entry.getKey();
                    jars.add(artifact.getFile());
                    if (!this.createSourcesJar || (file = this.resolveArtifactSources(artifact)) == null) continue;
                    jars.add(file);
                }
                if (jars.isEmpty()) {
                    this.getLog().info((CharSequence)("No artifact matching filter " + filter.getArtifact()));
                    continue;
                }
                simpleFilters.add(new SimpleFilter(jars, filter.getIncludes(), filter.getExcludes()));
            }
        }
        filters.addAll(simpleFilters);
        if (this.minimizeJar) {
            this.getLog().info((CharSequence)("Minimizing jar " + this.project.getArtifact()));
            try {
                filters.add(new MinijarFilter(this.project, this.getLog(), simpleFilters));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to analyze class dependencies", (Exception)e);
            }
        }
        return filters;
    }

    private File shadedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourceArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedTestArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "-tests." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourcesArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.project.getBuild().getFinalName() != null ? this.project.getBuild().getFinalName() + "-sources." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "-sources." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedTestArtifactFile() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.project.getBuild().getFinalName() != null ? this.project.getBuild().getFinalName() + "-tests." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "-tests." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDependencyReducedPom(Set<String> artifactsToRemove) throws IOException, DependencyGraphBuilderException, ProjectBuildingException {
        Model model = this.project.getOriginalModel();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        ArrayList<Dependency> transitiveDeps = new ArrayList<Dependency>();
        for (Object artifact : this.project.getArtifacts()) {
            if ("pom".equals(artifact.getType())) continue;
            Dependency dep = new Dependency();
            dep.setArtifactId(artifact.getArtifactId());
            if (artifact.hasClassifier()) {
                dep.setClassifier(artifact.getClassifier());
            }
            dep.setGroupId(artifact.getGroupId());
            dep.setOptional(artifact.isOptional());
            dep.setScope(artifact.getScope());
            dep.setType(artifact.getType());
            if (this.useBaseVersion) {
                dep.setVersion(artifact.getBaseVersion());
            } else {
                dep.setVersion(artifact.getVersion());
            }
            transitiveDeps.add(dep);
        }
        ArrayList<Dependency> origDeps = this.project.getDependencies();
        if (this.promoteTransitiveDependencies) {
            origDeps = transitiveDeps;
        }
        for (Dependency d : origDeps) {
            dependencies.add(d);
            String id = this.getId(d);
            if (!artifactsToRemove.contains(id)) continue;
            modified = true;
            if (this.keepDependenciesWithProvidedScope) {
                d.setScope("provided");
                continue;
            }
            dependencies.remove(d);
        }
        if (modified) {
            while (modified) {
                model.setDependencies(dependencies);
                if (this.generateUniqueDependencyReducedPom) {
                    this.dependencyReducedPomLocation = File.createTempFile("dependency-reduced-pom-", ".xml", this.project.getBasedir());
                    this.project.getProperties().setProperty("maven.shade.dependency-reduced-pom", this.dependencyReducedPomLocation.getAbsolutePath());
                } else if (this.dependencyReducedPomLocation == null) {
                    this.dependencyReducedPomLocation = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
                }
                File f = this.dependencyReducedPomLocation;
                this.getLog().info((CharSequence)("Dependency-reduced POM written at: " + f.getAbsolutePath()));
                if (f.exists()) {
                    f.delete();
                }
                XmlStreamWriter w = WriterFactory.newXmlWriter((File)f);
                String replaceRelativePath = null;
                if (model.getParent() != null) {
                    replaceRelativePath = model.getParent().getRelativePath();
                }
                if (model.getParent() != null) {
                    File parentFile = new File(this.project.getBasedir(), model.getParent().getRelativePath()).getCanonicalFile();
                    if (!parentFile.isFile()) {
                        parentFile = new File(parentFile, "pom.xml");
                    }
                    parentFile = parentFile.getCanonicalFile();
                    String relPath = RelativizePath.convertToRelativePath(parentFile, f);
                    model.getParent().setRelativePath(relPath);
                }
                try {
                    PomWriter.write((Writer)w, model, true);
                }
                finally {
                    if (model.getParent() != null) {
                        model.getParent().setRelativePath(replaceRelativePath);
                    }
                    w.close();
                }
                DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                projectBuildingRequest.setLocalRepository(this.localRepository);
                projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
                ProjectBuildingResult result = this.projectBuilder.build(f, (ProjectBuildingRequest)projectBuildingRequest);
                modified = this.updateExcludesInDeps(result.getProject(), dependencies, transitiveDeps);
            }
            this.project.setFile(this.dependencyReducedPomLocation);
        }
    }

    private String getId(Artifact artifact) {
        return this.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    private String getId(Dependency dependency) {
        return this.getId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier());
    }

    private String getId(String groupId, String artifactId, String type, String classifier) {
        return groupId + ":" + artifactId + ":" + type + ":" + (classifier != null ? classifier : "");
    }

    public boolean updateExcludesInDeps(MavenProject project, List<Dependency> dependencies, List<Dependency> transitiveDeps) throws DependencyGraphBuilderException {
        DependencyNode node = this.dependencyGraphBuilder.buildDependencyGraph(project, null);
        boolean modified = false;
        for (DependencyNode n2 : node.getChildren()) {
            block1: for (DependencyNode n3 : n2.getChildren()) {
                boolean found = false;
                for (Dependency dep : transitiveDeps) {
                    if (!dep.getArtifactId().equals(n3.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n3.getArtifact().getGroupId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                for (Dependency dep : dependencies) {
                    if (!dep.getArtifactId().equals(n2.getArtifact().getArtifactId()) || !dep.getGroupId().equals(n2.getArtifact().getGroupId())) continue;
                    Exclusion exclusion = new Exclusion();
                    exclusion.setArtifactId(n3.getArtifact().getArtifactId());
                    exclusion.setGroupId(n3.getArtifact().getGroupId());
                    dep.addExclusion(exclusion);
                    modified = true;
                    continue block1;
                }
            }
        }
        return modified;
    }
}

