/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.ClassDependencies;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinijarFilter
implements Filter {
    private final Log log;
    private final Set<String> unusedClasses;
    private int classesKept;
    private int classesRemoved;
    private final List<SimpleFilter> simpleFilters;

    public MinijarFilter(MavenProject project, Log log, List<SimpleFilter> simpleFilters) throws IOException {
        this.log = log;
        this.simpleFilters = (List)Objects.firstNonNull(simpleFilters, Collections.emptyList());
        ClassDependencies dependenciesBuilder = new ClassDependencies(this.simpleFilters);
        dependenciesBuilder.allClassesSpecificallyIncluded = true;
        this.readDependencyJar(dependenciesBuilder, project.getArtifact());
        dependenciesBuilder.allClassesSpecificallyIncluded = false;
        for (Artifact dependencyArtifact : project.getArtifacts()) {
            this.readDependencyJar(dependenciesBuilder, dependencyArtifact);
        }
        this.unusedClasses = dependenciesBuilder.buildAllUnusedClasses();
    }

    private void readDependencyJar(ClassDependencies dependenciesBuilder, Artifact artifact) throws IOException {
        try {
            dependenciesBuilder.addJar(artifact.getFile());
        }
        catch (ZipException e) {
            this.log.warn((CharSequence)String.format("Dependency %s in file %s could not read as JAR file. File is probably corrupt", artifact, artifact.getFile()));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.warn((CharSequence)(artifact + " could not be analyzed for minimization; dependency is probably malformed."));
        }
    }

    @Override
    public boolean canFilter(File jar) {
        return true;
    }

    @Override
    public boolean isFiltered(String name) {
        String typeName;
        if (name.endsWith(".class")) {
            String typeName2 = name.substring(0, name.length() - ".class".length());
            if (this.unusedClasses.contains(typeName2)) {
                this.log.debug((CharSequence)("Removing unused class: " + typeName2));
                ++this.classesRemoved;
                return true;
            }
            ++this.classesKept;
            return false;
        }
        if (name.startsWith("META-INF/services/") && this.unusedClasses.contains(typeName = ClassDependencies.toClassFilePath(name.substring("META-INF/services/".length())))) {
            this.log.debug((CharSequence)("Removing services for unused class: " + name));
            return true;
        }
        return false;
    }

    @Override
    public void finished() {
        int classesTotal = this.classesRemoved + this.classesKept;
        this.log.info((CharSequence)("Minimized " + classesTotal + " -> " + this.classesKept + " (" + 100 * this.classesKept / classesTotal + "%)"));
    }
}

