/*
 * Decompiled with CFR 0.152.
 */
package org.hjug.git;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lombok.Generated;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.hjug.git.ScmLogInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLogReader
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitLogReader.class);
    static final String JAVA_FILE_TYPE = ".java";
    private Repository gitRepository;
    private Git git;

    public GitLogReader() {
    }

    public GitLogReader(File basedir) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(basedir);
        String gitIndexFileEnvVariable = System.getenv("GIT_INDEX_FILE");
        if (Objects.nonNull(gitIndexFileEnvVariable) && !gitIndexFileEnvVariable.trim().isEmpty()) {
            log.debug("Setting Index File based on Env Variable GIT_INDEX_FILE {}", (Object)gitIndexFileEnvVariable);
            repositoryBuilder = (FileRepositoryBuilder)repositoryBuilder.setIndexFile(new File(gitIndexFileEnvVariable));
        }
        this.git = Git.open((File)repositoryBuilder.getGitDir());
        this.gitRepository = this.git.getRepository();
    }

    GitLogReader(Git git) {
        this.git = git;
        this.gitRepository = git.getRepository();
    }

    @Override
    public void close() throws Exception {
        this.git.close();
    }

    public Repository gitRepository(File basedir) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(basedir);
        String gitIndexFileEnvVariable = System.getenv("GIT_INDEX_FILE");
        if (Objects.nonNull(gitIndexFileEnvVariable) && !gitIndexFileEnvVariable.trim().isEmpty()) {
            log.debug("Setting Index File based on Env Variable GIT_INDEX_FILE {}", (Object)gitIndexFileEnvVariable);
            repositoryBuilder = (FileRepositoryBuilder)repositoryBuilder.setIndexFile(new File(gitIndexFileEnvVariable));
        }
        Repository gitRepository = repositoryBuilder.build();
        return gitRepository;
    }

    public File getGitDir(File basedir) {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(basedir);
        return repositoryBuilder.getGitDir();
    }

    public Map<String, ByteArrayOutputStream> listRepositoryContentsAtHEAD(Repository repository) throws IOException {
        Ref head = repository.exactRef("HEAD");
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
        RevTree tree = commit.getTree();
        TreeWalk treeWalk = new TreeWalk(repository);
        treeWalk.addTree((AnyObjectId)tree);
        treeWalk.setRecursive(false);
        HashMap<String, ByteArrayOutputStream> fileContentsCollection = new HashMap<String, ByteArrayOutputStream>();
        while (treeWalk.next()) {
            if (treeWalk.isSubtree()) {
                treeWalk.enterSubtree();
                continue;
            }
            if (!treeWalk.getPathString().endsWith(JAVA_FILE_TYPE)) continue;
            ObjectId objectId = treeWalk.getObjectId(0);
            ObjectLoader loader = repository.open((AnyObjectId)objectId);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            loader.copyTo((OutputStream)outputStream);
            fileContentsCollection.put(treeWalk.getPathString(), outputStream);
        }
        return fileContentsCollection;
    }

    public ScmLogInfo fileLog(String path) throws GitAPIException, IOException {
        ObjectId branchId = this.gitRepository.resolve("HEAD");
        Iterable revCommits = this.git.log().add((AnyObjectId)branchId).addPath(path).call();
        int commitCount = 0;
        int earliestCommit = Integer.MAX_VALUE;
        for (RevCommit revCommit : revCommits) {
            if (revCommit.getCommitTime() < earliestCommit) {
                earliestCommit = revCommit.getCommitTime();
            }
            ++commitCount;
        }
        int mostRecentCommit = ((RevCommit)this.git.log().add((AnyObjectId)branchId).addPath(path).setMaxCount(1).call().iterator().next()).getCommitTime();
        return new ScmLogInfo(path, earliestCommit, mostRecentCommit, commitCount);
    }

    public TreeMap<Integer, Integer> captureChangeCountByCommitTimestamp() throws IOException, GitAPIException {
        TreeMap<Integer, Integer> changesByCommitTimestamp = new TreeMap<Integer, Integer>();
        ObjectId branchId = this.gitRepository.resolve("HEAD");
        Iterable commits = this.git.log().add((AnyObjectId)branchId).call();
        RevCommit newCommit = null;
        Iterator iterator = commits.iterator();
        while (iterator.hasNext()) {
            RevCommit oldCommit = (RevCommit)iterator.next();
            int count = 0;
            if (null == newCommit) {
                newCommit = oldCommit;
                continue;
            }
            for (DiffEntry entry : this.getDiffEntries(newCommit, oldCommit)) {
                if (!entry.getNewPath().endsWith(JAVA_FILE_TYPE) && !entry.getOldPath().endsWith(JAVA_FILE_TYPE)) continue;
                ++count;
            }
            if (count > 0) {
                changesByCommitTimestamp.put(newCommit.getCommitTime(), count);
            }
            if (!iterator.hasNext()) {
                changesByCommitTimestamp.putAll(this.walkFirstCommit(oldCommit));
            }
            newCommit = oldCommit;
        }
        return changesByCommitTimestamp;
    }

    private List<DiffEntry> getDiffEntries(RevCommit newCommit, RevCommit oldCommit) throws IOException {
        CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
        CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
        try (ObjectReader reader = this.git.getRepository().newObjectReader();){
            ObjectId oldTree = this.git.getRepository().resolve(newCommit.getTree().name());
            oldTreeIter.reset(reader, (AnyObjectId)oldTree);
            ObjectId newTree = this.git.getRepository().resolve(oldCommit.getTree().name());
            newTreeIter.reset(reader, (AnyObjectId)newTree);
        }
        DiffFormatter df = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        df.setRepository(this.git.getRepository());
        return df.scan((AbstractTreeIterator)oldTreeIter, (AbstractTreeIterator)newTreeIter);
    }

    Map<Integer, Integer> walkFirstCommit(RevCommit firstCommit) throws IOException {
        TreeMap<Integer, Integer> changesByCommitTimestamp = new TreeMap<Integer, Integer>();
        int firstCommitCount = 0;
        RevTree treeId = firstCommit.getTree();
        try (TreeWalk treeWalk = new TreeWalk(this.gitRepository);){
            treeWalk.setRecursive(false);
            treeWalk.reset((AnyObjectId)treeId);
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) {
                    treeWalk.enterSubtree();
                    continue;
                }
                if (!treeWalk.getPathString().endsWith(JAVA_FILE_TYPE)) continue;
                ++firstCommitCount;
            }
        }
        if (firstCommitCount > 0) {
            changesByCommitTimestamp.put(firstCommit.getCommitTime(), firstCommitCount);
        }
        return changesByCommitTimestamp;
    }
}

