/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionInnerStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.spi.ProjectionConstructorPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorIdentifier;
import org.hibernate.search.mapper.pojo.search.definition.impl.ConstructorProjectionApplicationException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class PojoConstructorProjectionDefinition<T>
implements CompositeProjectionDefinition<T>,
ToStringTreeAppendable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoConstructorIdentifier constructor;
    private final ValueCreateHandle<? extends T> handle;
    private final List<BeanHolder<? extends ProjectionDefinition<?>>> parameters;

    public PojoConstructorProjectionDefinition(PojoConstructorIdentifier constructor, ValueCreateHandle<? extends T> valueCreateHandle, List<BeanHolder<? extends ProjectionDefinition<?>>> parameters) {
        this.constructor = constructor;
        this.handle = valueCreateHandle;
        this.parameters = parameters;
    }

    public String toString() {
        return "PojoConstructorProjectionDefinition[constructor=" + String.valueOf(this.constructor) + "]";
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("constructor", (Object)this.constructor);
        appender.startList("parameters");
        for (BeanHolder<? extends ProjectionDefinition<?>> beanHolder : this.parameters) {
            appender.value(beanHolder.get());
        }
        appender.endList();
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(BeanHolder::close, this.parameters);
        }
    }

    public CompositeProjectionValueStep<?, T> apply(SearchProjectionFactory<?, ?> projectionFactory, CompositeProjectionInnerStep initialStep, ProjectionDefinitionContext context) {
        int i = -1;
        try {
            SearchProjection[] innerProjections = new SearchProjection[this.parameters.size()];
            for (i = 0; i < this.parameters.size(); ++i) {
                innerProjections[i] = ((ProjectionDefinition)this.parameters.get(i).get()).create(projectionFactory, context);
            }
            return initialStep.from(innerProjections).asArray(this.handle);
        }
        catch (ConstructorProjectionApplicationException e) {
            ProjectionConstructorPath path = new ProjectionConstructorPath(this.constructor, e.projectionConstructorPath(), i);
            throw log.errorApplyingProjectionConstructor(e.getCause().getMessage(), (Exception)((Object)e), path);
        }
        catch (SearchException e) {
            ProjectionConstructorPath path = new ProjectionConstructorPath(this.constructor);
            throw log.errorApplyingProjectionConstructor(e.getMessage(), (Exception)((Object)e), path);
        }
    }
}

