/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ValueProcessor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractingProcessor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.util.common.impl.Closer;

final class ChainingContainerExtractorHolder<C, U, V>
implements ContainerExtractorHolder<C, V> {
    private final ContainerExtractorHolder<C, U> base;
    private final BeanHolder<? extends ContainerExtractor<? super U, V>> chained;

    public ChainingContainerExtractorHolder(ContainerExtractorHolder<C, U> base, BeanHolder<? extends ContainerExtractor<? super U, V>> chained) {
        this.base = base;
        this.chained = chained;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        this.appendToString(builder);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ContainerExtractorHolder::close, this.base);
            closer.push(BeanHolder::close, this.chained);
        }
    }

    @Override
    public <T, C2> ValueProcessor<T, C, C2> wrap(ValueProcessor<T, ? super V, C2> perValueProcessor) {
        return this.base.wrap(new ContainerExtractingProcessor((ContainerExtractor)this.chained.get(), perValueProcessor));
    }

    @Override
    public boolean multiValued() {
        return this.base.multiValued() || ((ContainerExtractor)this.chained.get()).multiValued();
    }

    @Override
    public void appendToString(StringBuilder builder) {
        this.base.appendToString(builder);
        builder.append(", ");
        builder.append(this.chained);
    }
}

