/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.Bucket;
import org.hibernate.search.backend.lucene.types.aggregation.impl.BucketOrder;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LocalAggregationExtractContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LongBucket;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;

public abstract class AbstractLuceneMultivaluedTermsAggregation<F, T, K, V, R>
extends AbstractLuceneBucketAggregation<K, R> {
    protected final ProjectionConverter<V, ? extends K> fromFieldValueConverter;
    protected final BucketOrder order;
    protected final int maxTermCount;
    protected final int minDocCount;
    protected final LuceneSearchAggregation<R> aggregation;

    AbstractLuceneMultivaluedTermsAggregation(AbstractBuilder<F, T, K, V, R> builder) {
        super(builder);
        this.fromFieldValueConverter = builder.fromFieldValueConverter;
        this.order = builder.order;
        this.maxTermCount = builder.maxTermCount;
        this.minDocCount = builder.minDocCount;
        this.aggregation = builder.aggregation;
    }

    static abstract class AbstractBuilder<F, T, K, V, R>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<K, R>
    implements TermsAggregationBuilder<K, R> {
        protected final LuceneSearchAggregation<R> aggregation;
        protected final ProjectionConverter<V, ? extends K> fromFieldValueConverter;
        protected BucketOrder order;
        protected int minDocCount;
        protected int maxTermCount;

        AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, LuceneSearchAggregation<R> aggregation, ProjectionConverter<V, ? extends K> fromFieldValueConverter) {
            this(scope, field, aggregation, fromFieldValueConverter, BucketOrder.COUNT_DESC, 1, 100);
        }

        AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field, LuceneSearchAggregation<R> aggregation, ProjectionConverter<V, ? extends K> fromFieldValueConverter, BucketOrder order, int minDocCount, int maxTermCount) {
            super(scope, field);
            this.aggregation = aggregation;
            this.fromFieldValueConverter = fromFieldValueConverter;
            this.order = order;
            this.minDocCount = minDocCount;
            this.maxTermCount = maxTermCount;
        }

        public void orderByCountDescending() {
            this.order(BucketOrder.COUNT_DESC);
        }

        public void orderByCountAscending() {
            this.order(BucketOrder.COUNT_ASC);
        }

        public void orderByTermAscending() {
            this.order(BucketOrder.TERM_ASC);
        }

        public void orderByTermDescending() {
            this.order(BucketOrder.TERM_DESC);
        }

        public void minDocumentCount(int minDocumentCount) {
            this.minDocCount = minDocumentCount;
        }

        public void maxTermCount(int maxTermCount) {
            this.maxTermCount = maxTermCount;
        }

        @Override
        public abstract AbstractLuceneMultivaluedTermsAggregation<F, T, K, V, R> build();

        protected final void order(BucketOrder order) {
            this.order = order;
        }
    }

    static abstract class AbstractTypeSelector<F>
    implements TermsAggregationBuilder.TypeSelector {
        protected final LuceneSearchIndexScope<?> scope;
        protected final LuceneSearchIndexValueFieldContext<F> field;

        protected AbstractTypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.scope = scope;
            this.field = field;
        }

        public abstract <K> AbstractBuilder<F, ?, K, ?, Long> type(Class<K> var1, ValueModel var2);
    }

    protected abstract class AbstractExtractor
    implements LuceneSearchAggregation.Extractor<Map<K, R>> {
        protected final LuceneSearchAggregation.Extractor<R> extractor;

        protected AbstractExtractor(LuceneSearchAggregation.Extractor<R> extractor) {
            this.extractor = extractor;
        }

        @Override
        public final Map<K, R> extract(AggregationExtractContext context) throws IOException {
            List buckets = this.getTopBuckets(context);
            if (AbstractLuceneMultivaluedTermsAggregation.this.minDocCount == 0 && buckets.size() < AbstractLuceneMultivaluedTermsAggregation.this.maxTermCount) {
                Set<Object> firstTerms = this.collectFirstTerms(context.getIndexReader(), AbstractLuceneMultivaluedTermsAggregation.this.order.isTermOrderDescending(), AbstractLuceneMultivaluedTermsAggregation.this.maxTermCount);
                for (Bucket bucket : buckets) {
                    firstTerms.remove(bucket.term());
                }
                Object zeroValue = this.createZeroValue(context);
                firstTerms.forEach(term -> buckets.add(new Bucket<Object, Object>(term, 0L, zeroValue)));
                buckets.sort(AbstractLuceneMultivaluedTermsAggregation.this.order.toBucketComparator(this.getAscendingTermComparator()));
            }
            return this.toMap(context.fromDocumentValueConvertContext(), buckets);
        }

        protected abstract TermResults termResults(AggregationExtractContext var1) throws IOException;

        protected R createZeroValue(AggregationExtractContext context) throws IOException {
            LocalAggregationExtractContext localContext = new LocalAggregationExtractContext(context);
            TermResults termResults = this.termResults(context);
            CollectorManager<Collector, ?>[] managers = termResults.collectorManagers();
            CollectorKey<?, ?>[] keys = termResults.collectorKeys();
            HashMap results = new HashMap();
            for (int i = 0; i < keys.length; ++i) {
                results.put(keys[i], managers[i].reduce(List.of(managers[i].newCollector())));
            }
            localContext.setResults(results);
            return this.extractor.extract(localContext);
        }

        abstract Set<T> collectFirstTerms(IndexReader var1, boolean var2, int var3) throws IOException;

        abstract Comparator<T> getAscendingTermComparator();

        abstract V termToFieldValue(T var1);

        abstract List<Bucket<T, R>> getTopBuckets(AggregationExtractContext var1) throws IOException;

        private Map<K, R> toMap(FromDocumentValueConvertContext convertContext, List<Bucket<T, R>> buckets) {
            LinkedHashMap result = new LinkedHashMap();
            for (Bucket bucket : buckets) {
                Object decoded = this.termToFieldValue(bucket.term());
                Object key = AbstractLuceneMultivaluedTermsAggregation.this.fromFieldValueConverter.fromDocumentValue(decoded, convertContext);
                result.put(key, bucket.value());
            }
            return result;
        }

        protected Map<CollectorKey<?, ?>, Object> prepareResults(LongBucket bucket, TermResults termResults) throws IOException {
            HashMap result = new HashMap();
            List<Collector>[] collectors = bucket.collectors;
            CollectorKey<?, ?>[] collectorKeys = termResults.collectorKeys();
            CollectorManager<Collector, ?>[] managers = termResults.collectorManagers();
            for (int i = 0; i < collectorKeys.length; ++i) {
                result.put(collectorKeys[i], managers[i].reduce(collectors[i]));
            }
            return result;
        }
    }
}

