/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaValueFieldNode;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchObjectFieldContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchObjectFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectExistsPredicate;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexObjectFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexObjectFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.util.common.SearchException;

public class LuceneIndexSchemaObjectFieldNode
extends AbstractLuceneIndexSchemaFieldNode
implements IndexObjectFieldDescriptor,
LuceneIndexSchemaObjectNode,
IndexObjectFieldTypeDescriptor,
LuceneSearchObjectFieldContext {
    private final List<String> nestedPathHierarchy;
    private final ObjectStructure structure;
    private final Map<String, AbstractLuceneIndexSchemaFieldNode> staticChildrenByName;

    public LuceneIndexSchemaObjectFieldNode(LuceneIndexSchemaObjectNode parent, String relativeName, IndexFieldInclusion inclusion, ObjectStructure structure, boolean multiValued, boolean dynamic, Map<String, AbstractLuceneIndexSchemaFieldNode> notYetInitializedStaticChildren) {
        super(parent, relativeName, inclusion, multiValued, dynamic);
        List<String> theNestedPathHierarchy = parent.nestedPathHierarchy();
        if (ObjectStructure.NESTED.equals((Object)structure)) {
            theNestedPathHierarchy = new ArrayList<String>(theNestedPathHierarchy);
            theNestedPathHierarchy.add(this.absolutePath);
        }
        this.nestedPathHierarchy = Collections.unmodifiableList(theNestedPathHierarchy);
        this.structure = structure;
        this.staticChildrenByName = Collections.unmodifiableMap(notYetInitializedStaticChildren);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + ", structure=" + this.structure + "]";
    }

    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isObjectField() {
        return true;
    }

    public boolean isValueField() {
        return false;
    }

    @Override
    public LuceneIndexSchemaObjectFieldNode toObjectField() {
        return this;
    }

    @Override
    public LuceneIndexSchemaValueFieldNode<?> toValueField() {
        throw log.invalidIndexElementTypeObjectFieldIsNotValueField(this.absolutePath);
    }

    @Override
    public String absolutePath(String relativeFieldName) {
        return FieldPaths.compose((String)this.absolutePath, (String)relativeFieldName);
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public IndexObjectFieldTypeDescriptor type() {
        return this;
    }

    @Override
    public Map<String, ? extends AbstractLuceneIndexSchemaFieldNode> staticChildrenByName() {
        return this.staticChildrenByName;
    }

    @Override
    public boolean nested() {
        return ObjectStructure.NESTED.equals((Object)this.structure);
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, LuceneSearchContext searchContext) {
        LuceneSearchObjectFieldQueryElementFactory<T> factory = this.queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForObjectField(this.absolutePath(), key.toString(), this.eventContext());
        }
        try {
            return factory.create(searchContext, this);
        }
        catch (SearchException e) {
            throw log.cannotUseQueryElementForObjectFieldBecauseCreationException(this.absolutePath, key.toString(), e.getMessage(), e, null);
        }
    }

    @Override
    public <T> LuceneSearchObjectFieldQueryElementFactory<T> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        if (PredicateTypeKeys.EXISTS.equals(key)) {
            return LuceneObjectExistsPredicate.Factory.INSTANCE;
        }
        return null;
    }

    public ObjectStructure structure() {
        return this.structure;
    }
}

