/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.hibernate.validator.jtype.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    private ReflectionHelper() {
    }

    static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        try {
            Method m = annotation.getClass().getMethod(parameterName, new Class[0]);
            Object o = m.invoke((Object)annotation, new Object[0]);
            if (o.getClass().getName().equals(type.getName())) {
                return (T)o;
            }
            String msg = "Wrong parameter type. Expected: " + type.getName() + " Actual: " + o.getClass().getName();
            throw new ValidationException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "The specified annotation defines no parameter '" + parameterName + "'.";
            throw new ValidationException(msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, (Throwable)e);
        }
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            if (methodName.startsWith("is")) {
                name = Introspector.decapitalize(methodName.substring(2));
            } else if (methodName.startsWith("has")) {
                name = Introspector.decapitalize(methodName.substring(3));
            } else if (methodName.startsWith("get")) {
                name = Introspector.decapitalize(methodName.substring(3));
            }
        }
        return name;
    }

    public static Class<?> getType(Member member) {
        Class<?> type = null;
        if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        if (member instanceof Method) {
            type = ((Method)member).getReturnType();
        }
        return type;
    }

    public static Type typeOf(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw new IllegalArgumentException("Member " + member + " is neither a field nor a method");
    }

    public static Object getValue(Member member, Object object) {
        Object value = null;
        if (member instanceof Method) {
            Method method = (Method)member;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + field.getName(), (Throwable)e);
            }
        }
        return value;
    }

    static void setAccessibility(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isIterable(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[0];
        } else if (ReflectionHelper.isMap(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            indexedType = paramType.getActualTypeArguments()[1];
        } else if (TypeUtils.isArray(type)) {
            indexedType = TypeUtils.getComponentType(type);
        }
        return indexedType;
    }

    public static boolean isIterable(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, Iterable.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isIterable(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isIterable(upperBounds[0]);
        }
        return false;
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, Map.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isMap(upperBounds[0]);
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type instanceof Class && ReflectionHelper.extendsOrImplements((Class)type, List.class)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && ReflectionHelper.isList(upperBounds[0]);
        }
        return false;
    }

    public static Object getIndexedValue(Object value, Integer index) {
        Iterator<Object> iter;
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        } else {
            return null;
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == index) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static Object getMappedValue(Object value, Object key) {
        if (value == null || !(value instanceof Map)) {
            return null;
        }
        Map map = (Map)value;
        return map.get(key);
    }

    static Method getMethod(Class<?> clazz, String methodName) {
        try {
            char[] string = methodName.toCharArray();
            string[0] = Character.toUpperCase(string[0]);
            methodName = new String(string);
            try {
                return clazz.getMethod("get" + methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return clazz.getMethod("is" + methodName, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class<?> boxedType(Type primitiveType) {
        if (!(primitiveType instanceof Class) && !((Class)primitiveType).isPrimitive()) {
            throw new IllegalArgumentException(primitiveType.getClass() + "has to be a primitive type");
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        throw new RuntimeException("Unhandled primitive type.");
    }

    public static void computeClassHierarchy(Class<?> clazz, List<Class<?>> classes) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                ReflectionHelper.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private static boolean extendsOrImplements(Class<?> clazz, Class<?> superClassOrInterface) {
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(clazz, classes);
        return classes.contains(superClassOrInterface);
    }
}

