/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.impl.ClosureArgumentNode;
import com.oracle.truffle.nfi.impl.ClosureNativePointer;
import com.oracle.truffle.nfi.impl.LibFFIClosureFactory;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativeString;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import java.nio.ByteBuffer;

@ExportLibrary(value=InteropLibrary.class)
final class LibFFIClosure
implements TruffleObject {
    final ClosureNativePointer nativePointer;

    static LibFFIClosure create(LibFFISignature signature, Object executable, TruffleLanguage.ContextReference<NFIContext> ctxRef) {
        CompilerAsserts.neverPartOfCompilation();
        LibFFIClosure ret = new LibFFIClosure((NFIContext)ctxRef.get(), signature, executable);
        ret.nativePointer.registerManagedRef(ret);
        return ret;
    }

    static LibFFIClosure newClosureWrapper(ClosureNativePointer nativePointer) {
        LibFFIClosure ret = new LibFFIClosure(nativePointer);
        ret.nativePointer.registerManagedRef(ret);
        return ret;
    }

    private LibFFIClosure(NFIContext context, LibFFISignature signature, Object executable) {
        LibFFIType.CachedTypeInfo retType = signature.signatureInfo.getRetType();
        if (retType instanceof LibFFIType.ObjectType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ObjectRetClosureRootNode(signature.signatureInfo, executable));
            this.nativePointer = context.allocateClosureObjectRet(signature, (CallTarget)executeCallTarget);
        } else if (retType instanceof LibFFIType.NullableType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new NullableRetClosureRootNode(signature.signatureInfo, executable));
            this.nativePointer = context.allocateClosureObjectRet(signature, (CallTarget)executeCallTarget);
        } else if (retType instanceof LibFFIType.StringType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new StringRetClosureRootNode(signature.signatureInfo, executable));
            this.nativePointer = context.allocateClosureStringRet(signature, (CallTarget)executeCallTarget);
        } else if (retType instanceof LibFFIType.VoidType) {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new ObjectRetClosureRootNode(signature.signatureInfo, executable));
            this.nativePointer = context.allocateClosureVoidRet(signature, (CallTarget)executeCallTarget);
        } else {
            RootCallTarget executeCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new BufferRetClosureRootNode(signature.signatureInfo, executable));
            this.nativePointer = context.allocateClosureBufferRet(signature, (CallTarget)executeCallTarget);
        }
    }

    private LibFFIClosure(ClosureNativePointer nativePointer) {
        this.nativePointer = nativePointer;
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer.getCodePointer();
    }

    @ExportMessage
    LibFFIClosure toNative() {
        return this;
    }

    private static final class StringRetClosureRootNode
    extends RootNode {
        @Node.Child
        private CallClosureNode callClosure;
        @Node.Child
        private UnboxStringNode unboxString;

        private StringRetClosureRootNode(LibFFISignature.CachedSignatureInfo signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
            this.unboxString = LibFFIClosureFactory.UnboxStringNodeGen.create();
        }

        public Object execute(VirtualFrame frame) {
            Object ret = this.callClosure.execute(frame.getArguments());
            try {
                return this.unboxString.execute(ret);
            }
            catch (UnsupportedTypeException ex) {
                return null;
            }
        }
    }

    static abstract class UnboxStringNode
    extends Node {
        UnboxStringNode() {
        }

        protected abstract Object execute(Object var1) throws UnsupportedTypeException;

        @Specialization(limit="3")
        protected Object nativeString(Object str, @CachedLibrary(value="str") SerializeArgumentLibrary serialize) throws UnsupportedTypeException {
            RetStringBuffer retBuffer = new RetStringBuffer();
            CompilerDirectives.ensureVirtualized((Object)retBuffer);
            serialize.putString(str, retBuffer, 0);
            return retBuffer.ret;
        }
    }

    static final class RetStringBuffer
    extends NativeArgumentBuffer {
        Object ret;

        RetStringBuffer() {
            super(0);
        }

        @Override
        public int position() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void position(int newPosition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putPointer(long ptr, int size) {
            this.ret = new NativeString(ptr);
        }

        @Override
        public void putObject(NativeArgumentBuffer.TypeTag tag, Object o, int size) {
            assert (tag == NativeArgumentBuffer.TypeTag.STRING);
            this.ret = o;
        }

        @Override
        public byte getInt8() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt8(byte b) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public short getInt16() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt16(short s) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public int getInt32() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt32(int i) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public long getInt64() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putInt64(long l) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public float getFloat() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putFloat(float f) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public double getDouble() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }

        @Override
        public void putDouble(double d) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not reach here");
        }
    }

    private static final class NullableRetClosureRootNode
    extends RootNode {
        @Node.Child
        private CallClosureNode callClosure;
        @Node.Child
        private InteropLibrary interopLibrary;

        private NullableRetClosureRootNode(LibFFISignature.CachedSignatureInfo signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
            this.interopLibrary = (InteropLibrary)InteropLibrary.getFactory().createDispatched(4);
        }

        public Object execute(VirtualFrame frame) {
            Object ret = this.callClosure.execute(frame.getArguments());
            if (this.interopLibrary.isNull(ret)) {
                return null;
            }
            return ret;
        }
    }

    private static final class ObjectRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;

        private ObjectRetClosureRootNode(LibFFISignature.CachedSignatureInfo signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
        }

        public Object execute(VirtualFrame frame) {
            return this.callClosure.execute(frame.getArguments());
        }
    }

    private static final class BufferRetClosureRootNode
    extends RootNode {
        @Node.Child
        CallClosureNode callClosure;
        @Node.Child
        EncodeRetNode encodeRet;

        private BufferRetClosureRootNode(LibFFISignature.CachedSignatureInfo signature, Object receiver) {
            super(null);
            this.callClosure = new CallClosureNode(signature, receiver);
            this.encodeRet = new EncodeRetNode(signature.getRetType());
        }

        public Object execute(VirtualFrame frame) {
            ByteBuffer retBuffer = (ByteBuffer)frame.getArguments()[frame.getArguments().length - 1];
            Object ret = this.callClosure.execute(frame.getArguments());
            return this.encodeRet.execute(ret, retBuffer);
        }
    }

    private static final class EncodeRetNode
    extends Node {
        private final LibFFIType.CachedTypeInfo retType;
        @Node.Child
        NativeArgumentLibrary nativeArguments;

        private EncodeRetNode(LibFFIType.CachedTypeInfo retType) {
            this.retType = retType.overrideClosureRetType();
            this.nativeArguments = (NativeArgumentLibrary)NativeArgumentLibrary.getFactory().create((Object)this.retType);
        }

        RetPatches execute(Object ret, ByteBuffer retBuffer) {
            NativeArgumentBuffer.Direct nativeRetBuffer = new NativeArgumentBuffer.Direct(retBuffer, this.retType.objectCount);
            try {
                this.nativeArguments.serialize(this.retType, nativeRetBuffer, ret);
                if (nativeRetBuffer.getPatchCount() > 0) {
                    Object keepalive;
                    if (nativeRetBuffer.getPatchCount() == 1 && NativeArgumentBuffer.TypeTag.getTag(nativeRetBuffer.patches[0]) == NativeArgumentBuffer.TypeTag.KEEPALIVE && (keepalive = nativeRetBuffer.objects[0]) instanceof LibFFIClosure) {
                        ((LibFFIClosure)keepalive).nativePointer.addRef();
                        return null;
                    }
                    return new RetPatches(nativeRetBuffer.getPatchCount(), nativeRetBuffer.patches, nativeRetBuffer.objects);
                }
            }
            catch (UnsupportedTypeException unsupportedTypeException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class CallClosureNode
    extends Node {
        private final Object receiver;
        @Node.Child
        InteropLibrary interop;
        @Node.Children
        final ClosureArgumentNode[] argNodes;

        private CallClosureNode(LibFFISignature.CachedSignatureInfo signature, Object receiver) {
            this.receiver = receiver;
            this.interop = (InteropLibrary)InteropLibrary.getFactory().create(receiver);
            LibFFIType.CachedTypeInfo[] args = signature.getArgTypes();
            this.argNodes = new ClosureArgumentNode[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.argNodes[i] = args[i].createClosureArgumentNode();
            }
        }

        @ExplodeLoop
        Object execute(Object[] argBuffers) {
            Object[] args = new Object[this.argNodes.length];
            for (int i = 0; i < this.argNodes.length; ++i) {
                args[i] = this.argNodes[i].execute(argBuffers[i]);
            }
            try {
                return this.interop.execute(this.receiver, args);
            }
            catch (InteropException ex) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(ex);
            }
        }
    }

    static final class RetPatches {
        final int count;
        final int[] patches;
        final Object[] objects;

        RetPatches(int count, int[] patches, Object[] objects) {
            this.count = count;
            this.patches = patches;
            this.objects = objects;
        }
    }
}

