/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.CallSignatureNodeFactory;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;

abstract class CallSignatureNode
extends Node {
    CallSignatureNode() {
    }

    abstract Object execute(NFISignature var1, Object var2, Object[] var3) throws ArityException, UnsupportedTypeException, UnsupportedMessageException;

    static CallSignatureNode createOptimizedCall(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
        return CallSignatureNodeFactory.OptimizedCallSignatureNodeGen.create(retType, argsState);
    }

    static CallSignatureNode createOptimizedClosure(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
        return CallSignatureNodeFactory.OptimizedCallClosureNodeGen.create(retType, argsState);
    }

    static final class CallSignatureRootNode
    extends RootNode {
        @Node.Child
        CallSignatureNode callSignature;

        CallSignatureRootNode(NFILanguage language, CallSignatureNode callSignature) {
            super((TruffleLanguage)language);
            this.callSignature = callSignature;
        }

        public Object execute(VirtualFrame frame) {
            NFISignature signature = (NFISignature)frame.getArguments()[0];
            Object function = frame.getArguments()[1];
            Object[] args = (Object[])frame.getArguments()[2];
            try {
                return this.callSignature.execute(signature, function, args);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CallSignatureRootNode.silenceException(RuntimeException.class, (Exception)e);
            }
        }

        static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
            throw ex;
        }
    }

    static abstract class OptimizedCallClosureNode
    extends CallSignatureNode {
        @Node.Child
        ConvertTypeNode.OptimizedConvertTypeNode convertRet;
        @Node.Children
        final ConvertTypeNode.OptimizedConvertTypeNode[] convertArgs;
        final int managedArgCount;

        OptimizedCallClosureNode(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            this.convertRet = ConvertTypeNode.createOptimizedToNative(retType);
            this.convertArgs = new ConvertTypeNode.OptimizedConvertTypeNode[argsState.nativeArgCount];
            this.managedArgCount = argsState.managedArgCount;
            NFISignature.ArgsCachedState cur = argsState;
            for (int i = argsState.nativeArgCount - 1; i >= 0; --i) {
                this.convertArgs[i] = ConvertTypeNode.createOptimizedFromNative(cur.argType);
                cur = cur.prev;
            }
        }

        @ExplodeLoop
        Object[] prepareArgs(NFISignature signature, Object[] args) {
            Object[] preparedArgs = new Object[this.managedArgCount];
            int argIdx = 0;
            for (int i = 0; i < this.convertArgs.length; ++i) {
                if (this.convertArgs[i].typeState.managedArgCount != 1) continue;
                preparedArgs[argIdx++] = this.convertArgs[i].execute(signature.argTypes[i], args[i]);
            }
            assert (argIdx == this.managedArgCount);
            return preparedArgs;
        }

        @Specialization(limit="1")
        Object doCall(NFISignature signature, Object function, Object[] args, @Cached BranchProfile exception, @CachedLibrary(value="function") InteropLibrary interop) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != this.convertArgs.length) {
                exception.enter();
                throw ArityException.create((int)this.convertArgs.length, (int)args.length);
            }
            Object[] preparedArgs = this.prepareArgs(signature, args);
            Object ret = interop.execute(function, preparedArgs);
            return this.convertRet.execute(signature.retType, ret);
        }
    }

    static abstract class OptimizedCallSignatureNode
    extends CallSignatureNode {
        @Node.Child
        ConvertTypeNode.OptimizedConvertTypeNode convertRet;
        @Node.Children
        final ConvertTypeNode.OptimizedConvertTypeNode[] convertArgs;
        private final int managedArgCount;

        OptimizedCallSignatureNode(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            this.convertRet = ConvertTypeNode.createOptimizedFromNative(retType);
            this.convertArgs = new ConvertTypeNode.OptimizedConvertTypeNode[argsState.nativeArgCount];
            this.managedArgCount = argsState.managedArgCount;
            NFISignature.ArgsCachedState cur = argsState;
            for (int i = argsState.nativeArgCount - 1; i >= 0; --i) {
                this.convertArgs[i] = ConvertTypeNode.createOptimizedToNative(cur.argType);
                cur = cur.prev;
            }
        }

        @ExplodeLoop
        Object[] prepareArgs(NFISignature signature, Object[] args) {
            Object[] preparedArgs = new Object[this.convertArgs.length];
            int argIdx = 0;
            for (int i = 0; i < this.convertArgs.length; ++i) {
                Object input = null;
                if (this.convertArgs[i].typeState.managedArgCount == 1) {
                    input = args[argIdx++];
                }
                preparedArgs[i] = this.convertArgs[i].execute(signature.argTypes[i], input);
            }
            assert (argIdx == this.managedArgCount);
            return preparedArgs;
        }

        @Specialization(limit="1")
        Object doCall(NFISignature signature, Object function, Object[] args, @Cached BranchProfile exception, @CachedLibrary(value="signature.nativeSignature") NFIBackendSignatureLibrary backendLibrary) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != this.managedArgCount) {
                exception.enter();
                throw ArityException.create((int)this.managedArgCount, (int)args.length);
            }
            Object[] preparedArgs = this.prepareArgs(signature, args);
            Object ret = backendLibrary.call(signature.nativeSignature, function, preparedArgs);
            return this.convertRet.execute(signature.retType, ret);
        }
    }

    @GenerateUncached
    static abstract class CachedCallSignatureNode
    extends CallSignatureNode {
        CachedCallSignatureNode() {
        }

        @Specialization(guards={"cachedState != null", "signature.cachedState == cachedState"})
        Object doOptimizedDirect(NFISignature signature, Object function, Object[] args, @Cached(value="signature.cachedState") NFISignature.SignatureCachedState cachedState, @Cached(value="cachedState.createOptimizedSignatureCall()") CallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            assert (cachedState == signature.cachedState);
            return call.execute(signature, function, args);
        }

        @Specialization(replaces={"doOptimizedDirect"}, guards={"signature.cachedState != null"})
        Object doOptimizedIndirect(NFISignature signature, Object function, Object[] args, @Cached IndirectCallNode call) {
            return call.call(signature.cachedState.getPolymorphicSignatureCall(), new Object[]{signature, function, args});
        }

        @Specialization(limit="3", guards={"signature.cachedState == null"})
        Object doSlowPath(NFISignature signature, Object function, Object[] args, @Cached BranchProfile exception, @Cached ConvertTypeNode.ConvertToNativeNode convertArg, @Cached ConvertTypeNode.ConvertFromNativeNode convertRet, @CachedLibrary(value="signature.nativeSignature") NFIBackendSignatureLibrary nativeLibrary) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (args.length != signature.managedArgCount) {
                exception.enter();
                throw ArityException.create((int)signature.managedArgCount, (int)args.length);
            }
            Object[] preparedArgs = new Object[signature.nativeArgCount];
            int argIdx = 0;
            for (int i = 0; i < preparedArgs.length; ++i) {
                Object input = null;
                if (signature.argTypes[i].cachedState.managedArgCount == 1) {
                    input = args[argIdx++];
                }
                preparedArgs[i] = convertArg.execute(signature.argTypes[i], input);
            }
            Object ret = nativeLibrary.call(signature.nativeSignature, function, preparedArgs);
            return convertRet.execute(signature.retType, ret);
        }
    }
}

