/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.*;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.websocket.api.annotations.WebSocketMessage;
import org.glassfish.websocket.api.annotations.WebSocketClose;
import org.glassfish.websocket.api.annotations.WebSocketOpen;
import org.glassfish.websocket.api.annotations.WebSocketError;

/**
 *
 * @author dannycoward
 */


    @SupportedAnnotationTypes({"org.glassfish.websocket.api.annotations.WebSocket",
                                "org.glassfish.websocket.annotations.api.WebSocketMessage",
                                "org.glassfish.websocket.annotations.api.WebSocketClose",
                                "org.glassfish.websocket.annotations.api.WebSocketOpen",
                                "org.glassfish.websocket.annotations.api.WebSocketError",
                                "org.glassfish.websocket.annotations.api.WebSocketContext",
                                "org.glassfish.websocket.annotations.api.WebSocketRemote"})
    @SupportedSourceVersion(SourceVersion.RELEASE_6)
public class WSProcessor extends AbstractProcessor {

         /** public for ServiceLoader */
    public WSProcessor() {
    }

    public static String getWrapperClassnameFor(String qualifiedClassname, String path) {
        String className = qualifiedClassname.substring(qualifiedClassname.lastIndexOf(".")+1, qualifiedClassname.length());
        String fakePath = path.replace("/", "_"); // FIXIT
        return className + "_BeanWrapper" + "_at_" + fakePath;
    }

    public static String getQualifiedClassnameFor(String qualifiedClassname, String path) {
        return ProcessorUtils.getWrapperPackageNameFor(qualifiedClassname) + "." + getWrapperClassnameFor(qualifiedClassname, path);
    }

    @Override
    // called once per .java file passed in.
    // since each .java file (web socket bean may need more than one

    public boolean process(Set annotations, RoundEnvironment roundEnv) {
        RemoteProcessor rp = new RemoteProcessor(processingEnv);
        rp.process(annotations, roundEnv);
        return this.processReceiverMethods(annotations, roundEnv, rp);
    }

    private boolean processReceiverMethods(Set annotations, RoundEnvironment roundEnv, RemoteProcessor rp) {

        // now create a map with path -> (class -> (methods with that path))
        Map<String, ClassAndMethodsHolder> pathToClassAndMethodsHolder = this.analyzeWSAnnotations(annotations, roundEnv);
        //System.out.println(pathToClassAndMethodsHolder);
        // enumerate through the paths (each path gets a wrapper object)
        for (String eachPath : pathToClassAndMethodsHolder.keySet()) {
             try {
                 ClassAndMethodsHolder eachClassAndMethodsHolder = pathToClassAndMethodsHolder.get(eachPath);
                 TypeElement eachClazz = eachClassAndMethodsHolder.getClazz();
                 Set<Element> eachMethods = eachClassAndMethodsHolder.getMethods();
                 //System.out.println("-------" + eachMethods);
                 String wrapperPackage = ProcessorUtils.getWrapperPackageNameFor(eachClazz.getQualifiedName().toString());
                 String wrapperClassname = getWrapperClassnameFor(eachClazz.getQualifiedName().toString(), eachPath);

                 JavaFileObject f = processingEnv.getFiler().
                        createSourceFile(wrapperPackage + "." + wrapperClassname);

                processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE,
                        "Creating " + f.toUri());
                Writer w = f.openWriter();
                try {
                    PrintWriter pw = new PrintWriter(w);

                    ClassWriter.writeClass(wrapperPackage, wrapperClassname, eachClazz, eachMethods, rp, pw);

                    pw.flush();
                } finally {
                    w.close();
                }

            } catch (IOException x) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }

        return true;
    }

    private Map<String, ClassAndMethodsHolder> analyzeWSAnnotations(Set annotations, RoundEnvironment roundEnv) {
        Map<String, ClassAndMethodsHolder> pathToClassAndMethodsHolder = new HashMap<String, ClassAndMethodsHolder>();
        List<ClassPathMethodHolder> classPathMethodHolders = new ArrayList();

        List<Element> annotatedElements = new ArrayList<Element>();
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketMessage.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketClose.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketOpen.class));
        annotatedElements.addAll(roundEnv.getElementsAnnotatedWith(WebSocketError.class));
        //System.out.println(roundEnv.getRootElements());


        for (Element nextClass : roundEnv.getRootElements()) {

            String pathForClass = MethodWriter.getClassLevelPath(nextClass);

            if (nextClass instanceof TypeElement) {
                for (Element annotatedThing : annotatedElements) {
                    Set annotatedMethods = new HashSet();
                    if (annotatedThing.getKind() == ElementKind.METHOD
                            && annotatedThing.getEnclosingElement() == nextClass) {
                        // its an annotated method from this class
                        //System.out.println(annotatedThing);
                        String pathForEndPoint = pathForClass;
                        ClassPathMethodHolder cpmh = new ClassPathMethodHolder((TypeElement) nextClass, pathForEndPoint, annotatedThing);
                        classPathMethodHolders.add(cpmh);
                    }
                }
            } else {
                throw new RuntimeException("I don't know whut");
            }
        }
        //System.out.println("### " + classPathMethodHolders);
        for (ClassPathMethodHolder cpmh : classPathMethodHolders) {
            String nextPath = cpmh.getPath();
            ClassAndMethodsHolder camh;
            if (pathToClassAndMethodsHolder.get(nextPath) != null) {
                camh = pathToClassAndMethodsHolder.get(nextPath);
                camh.getMethods().add(cpmh.getMethod());
            } else {
                Set s = new HashSet();
                s.add(cpmh.getMethod());
                camh = new ClassAndMethodsHolder(cpmh.getClazz(), s);
                pathToClassAndMethodsHolder.put(nextPath, camh);
            }

        }
        //System.out.println("**** " + pathToClassAndMethodsHolder);
        return pathToClassAndMethodsHolder;
    }

    private List<Element> getElementsForClazz(Map<Element, TypeElement> elementToClassMap, TypeElement clazz) {
        List<Element> elements = new ArrayList<Element>();
        for (Element e : elementToClassMap.keySet()) {
            TypeElement nextClazz = elementToClassMap.get(e);
            if (nextClazz.equals(clazz)) {
                elements.add(e);
            }
        }
        return elements;
    }
}
