/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform.processors;

import java.io.IOException;
import java.io.PrintWriter;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.glassfish.websocket.api.annotations.WebSocketRemote;
import java.util.*;
import javax.lang.model.element.*;
import org.glassfish.websocket.api.annotations.WebSocket;

/**
 *
 * @author dannycoward
 */
public class RemoteClassWriter {

    static void writePackageAndImports(PrintWriter pw, String packageName) throws IOException {
        pw.println("package " + packageName + ";");
        pw.println();
        pw.println("import org.glassfish.grizzly.websockets.WebSocket;");
        pw.println("import org.glassfish.websocket.platform.*;");
        pw.println("import org.glassfish.websocket.api.ConversionException;");
        pw.println("import java.util.*;");
        pw.println("import java.io.*;");
        pw.println();
    }

    static void writeClassDeclaration(Element clazz, PrintWriter pw, String interfaceName, String classname, List<Element> methods, WebSocketRemote wsr) {
        pw.println("public class " + classname + " extends WebSocketWrapper implements "+interfaceName+" {");
        pw.println();

        pw.println("\tprivate String[] encoders = {");
        List<String> l = getEncoderClassesFrom((TypeElement) clazz, wsr);
        for (String c : l) {
            String quotedString = "\"" + c + "\"";
            if (l.indexOf(c) == 0) {
                pw.println("\t\t" + quotedString);

            } else {
                pw.println("\t\t," + quotedString);
            }


        }
        pw.println("\t};");
        pw.println();


        //pw.println("\tpublic " + classname + "(WebSocket socket) {");
        //pw.println("\t\tsuper(socket);");
        pw.println("");
        writeSendMethodImplementations(pw, methods);
        pw.println("}");
    }

    static List<String> getEncodersFrom(WebSocketRemote wsr) {


        /*

        String[] encoders = wsr.encoders();
        List<String> l = new ArrayList<String>();
        for (String encoder : wsr.encoders() ) {
            l.add(encoder);
        }*/
        return null;

    }

        // known verbosity of annotation processing api :(
    static List<String> getEncoderClassesFrom(TypeElement clazz, WebSocketRemote wsr) {
        List<String> encoders = new ArrayList<String>();
        for( AnnotationMirror am : clazz.getAnnotationMirrors() ) {

            // I know...
            boolean isAmWebSocketTypeMirror = am.getAnnotationType().toString().equals(WebSocketRemote.class.getCanonicalName());

            if (isAmWebSocketTypeMirror) {
                for (ExecutableElement elt : am.getElementValues().keySet()) {
                    //System.out.println(elt.getSimpleName() + " decoders");

                    if (elt.getSimpleName().toString().equals("encoders")) { // yuck
                        //System.out.println("IUYJBS");
                        List encodersL = (List) am.getElementValues().get(elt).getValue();
                        //System.out.println(decodersL);
                        for (Object nextDecoderClassnameDotClass : encodersL) {
                            //System.out.println("-" + next);
                            //System.out.println("-" + next.getClass());
                            // ok now we need to decide which of the decoders can cope with the method parameter
                            String dotClassname = nextDecoderClassnameDotClass.toString();
                            String classname = dotClassname.substring(0, dotClassname.length()-6);//".class"
                            encoders.add(classname);

                        }
                    }
                }
            }
        }


        return encoders;
    }


    static void writeSendMethodImplementations(PrintWriter pw, List<Element> methods) {
        for (Element method : methods) {
            String methodName = method.getSimpleName().toString();
            WebSocketRemote wsr = method.getAnnotation(WebSocketRemote.class);
            ExecutableElement eMethod = (ExecutableElement) method;
            VariableElement ve = eMethod.getParameters().get(0);
                // FIXIT check shape of the method here...
                // eMethod.getParameters() size = 1
            String parameterClassname = ve.asType().toString();
            String parameterName = ve.getSimpleName().toString();
            pw.println("\tpublic void " + methodName + "(" + parameterClassname + " " + parameterName + ") throws IOException, ConversionException {");

             // convert into a string
             // invoke socket
            //pw.println("\t\tsuper.doNothing();");
            pw.println("\t\tsuper.sendPolymorphic("+parameterName+", this.encoders);");
            /*
             // for now
            if ("".equals(wsr.encoder())) {
                if (parameterClassname.equals("java.lang.String")) {
                    pw.println("\t\tString messageAsString = " + parameterName + ";");
                } else if (parameterClassname.equals("int") ||
                        parameterClassname.equals("byte") ||
                        parameterClassname.equals("short") ||
                        parameterClassname.equals("long") ||
                        parameterClassname.equals("float") ||
                        parameterClassname.equals("double") ||
                        parameterClassname.equals("boolean") ||
                        parameterClassname.equals("char")) {
                    pw.println("\t\tObject messageAsObject = "+parameterName+";");
                    pw.println("\t\tString messageAsString = messageAsObject.toString();");
                    //pw.println(parameterClassname);
                } else {
                    throw new RuntimeException("Unknown parameter type is custom client");
                }

            } else {
                String encoderClassname = wsr.encoder();
                pw.println("\t\t"+encoderClassname+" encoder = new "+encoderClassname+"();");
                pw.println("\t\tString messageAsString = encoder.encode(" + parameterName + ");");
            }
            pw.println("\t\tsuper.sendMessage(messageAsString);");

            */
            pw.println();


             pw.println("\t}");
        }
        pw.println();

    }
}
