/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.glassfish.websocket.platform.processors;

import javax.lang.model.element.*;
import javax.lang.model.type.*;
import org.glassfish.websocket.api.annotations.PathSegment;
import org.glassfish.websocket.api.annotations.WebSocketMessage;

/**
 *
 * @author dannycoward
 */
public class OnMessageMethodHelper {
    ExecutableElement element;

    public OnMessageMethodHelper(ExecutableElement element) {
        if (element.getParameters().size() > 3) {
            throw new RuntimeException("Cannot deal with methods with more than 2 parameters right now. Sorry.");
        }
        if (element.getParameters().size() < 1) {
            throw new RuntimeException("Cannot deal with methods with no parameters right now. Sorry.");
        }
        this.element = element;
    }

    public String getMethodName() {
        return this.element.getSimpleName().toString();
    }


    public TypeMirror getReturnTypeMirror() {
        return element.getReturnType();
    }

    public boolean hasReturn() {
        return !(this.getReturnTypeMirror() instanceof NoType);
    }

    public WebSocketMessage getAnnotation() {
        return element.getAnnotation(WebSocketMessage.class);
    }

    public VariableElement getDataParameterElement() {
        return element.getParameters().get(0);
    }

    public VariableElement getPeerParameterElement() {
        if (element.getParameters().size() > 1) {
            for (int i = 1; i < element.getParameters().size(); i++) {
                VariableElement ve = element.getParameters().get(i);
                if (!isDynamicPath(ve)) {
                    return ve;
                }
            }
        }
        return null;
    }

    static boolean isDynamicPath(VariableElement parameter) {
        PathSegment ps = parameter.getAnnotation(PathSegment.class);
        return ps != null;
    }

    public VariableElement getDynamicPathParameterElement() {
        for (VariableElement ve : element.getParameters() ) {
            if (isDynamicPath(ve)) {
                return ve;
            }
        }
        return null;
    }



}
