/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 - 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.websocket.platform;

import org.glassfish.grizzly.websockets .*;
import java.lang.reflect.*;
import java.util.*;
import java.util.logging.*;
import org.glassfish.websocket.platform.processors.WSProcessor;

/**
 *
 * @author dannycoward
 */

public class BeanServer {
    static String hostname = "localhost"; // default server settings

    final static Logger logger = Logger.getLogger("wsplatform");
    List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private static ContainerContextImpl containerContext;

    public static ContainerContextImpl getContainerContext() {
        return containerContext;
    }

    public void closeWebSocketServer() {
        for (WebSocketApplication wsa : this.applications) {
            ((WebSocketEndpoint) wsa).remove();
            WebSocketEngine.getEngine().unregister(wsa);
            logger.info("Closing down : " + wsa);
        }
    }

    public void initWebSocketServer(String wsPath, int port, Set<Class<?>> fqWSBeanNames) throws Exception {
        //System.out.println("----Edited");
        this.containerContext = new ContainerContextImpl(this, wsPath, port);
        for (Class webSocketApplicationBeanClazz : fqWSBeanNames) {
            //Class webSocketApplicationBeanClazz = Class.forName(fqWSBeanName);
            Object webSocketApplicationBean = webSocketApplicationBeanClazz.newInstance();

            //logger.info("Loaded application bean " + webSocketApplicationBeanClazz + " ..." + webSocketApplicationBean);

            // introspect the bean and find all the paths....
            Map methodPathMap = this.getMethodToPathMap(webSocketApplicationBeanClazz);
            if (methodPathMap.isEmpty()) {
                logger.warning(webSocketApplicationBeanClazz + " has no path mappings");
            }
            WebSocketApplication applicationBeanWrapper = null;

            Set<String> allPathsForBean = new HashSet(methodPathMap.values());

            // create one adapter per path. So each class may have multiple adapters.
            for (String nextPath : allPathsForBean) {
                String wrapperClassname = WSProcessor.getQualifiedClassnameFor(webSocketApplicationBeanClazz.getCanonicalName(), nextPath);
                Set<Method> allMethodsForPath = getMethodsForPath(webSocketApplicationBeanClazz, nextPath);
                Set<String> allDecodersForBean = getDecodersForBean(webSocketApplicationBeanClazz);
                Set<String> allEncodersForBean = getEncodersForBean(webSocketApplicationBeanClazz);


                Class wrapperClass = webSocketApplicationBeanClazz.getClassLoader().loadClass(wrapperClassname); // NetBeans doesn't barf on this
                applicationBeanWrapper = (WebSocketApplication) wrapperClass.newInstance();

                //applicationBeanWrapper = new Manual_BeanDispatcher();

                //applicationBeanWrapper = new wsgenerated.BeanWrapper(); // NetBeans does barf on this
                String wrapperBeanPath = wsPath+ nextPath;
                ((Initable) applicationBeanWrapper).doInit(wrapperBeanPath, allDecodersForBean, allEncodersForBean, webSocketApplicationBean, allMethodsForPath);
                //logger.info("Created wrapper bean: " + applicationBeanWrapper);
                this.deploy(applicationBeanWrapper);
            }
        }
    }

    void deploy(WebSocketApplication wsa) {
        WebSocketEngine.getEngine().register(wsa);
        this.applications.add(wsa);
        logger.info("Registered a " + wsa.getClass() + " at " + ((WebSocketEndpoint) wsa).getPath());
    }

    private Set getMethodsForPath(Class beanClazz, String path) throws Exception {
        Set<Method> s = new HashSet<Method>();
        Map<Method, String> methodPath = this.getMethodToPathMap(beanClazz);
        for (Method m : methodPath.keySet()) {
            String p = methodPath.get(m);
            if (p.equals(path)) {
                s.add(m);
            }
        }
        return s;
    }

    private Set getEncodersForBean(Class beanClazz) throws Exception {
        Set encoders = new HashSet();
        org.glassfish.websocket.api.annotations.WebSocket wsClass = (org.glassfish.websocket.api.annotations.WebSocket) beanClazz.getAnnotation(org.glassfish.websocket.api.annotations.WebSocket.class);
        for (Class encoder : wsClass.encoders()) {
            encoders.add(encoder);
        }
        return encoders;
    }

    private Set getDecodersForBean(Class beanClazz) throws Exception {
        Set decoders = new HashSet();
        org.glassfish.websocket.api.annotations.WebSocket wsClass = (org.glassfish.websocket.api.annotations.WebSocket) beanClazz.getAnnotation(org.glassfish.websocket.api.annotations.WebSocket.class);
        for (Class decoder : wsClass.decoders()) {
            decoders.add(decoder);
        }
        return decoders;
    }


    private Map<Method, String> getMethodToPathMap(Class beanClazz) throws Exception {
        Map<Method, String> pathMappings = new HashMap();
        Method[] methods = beanClazz.getDeclaredMethods();
        for (Method method : methods) {
            org.glassfish.websocket.api.annotations.WebSocket wsClass = (org.glassfish.websocket.api.annotations.WebSocket) beanClazz.getAnnotation(org.glassfish.websocket.api.annotations.WebSocket.class);
            pathMappings.put(method, wsClass.path());
        }
        return pathMappings;
    }




}
