/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flywaydb.core.Flyway;
import org.springframework.core.io.ClassPathResource;

public class FlywayHelperFactory {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Flyway flyway;
    private Properties flywayProperties;

    public FlywayHelperFactory() {
        this.logger.info((Object)"Create flyway helper factory.");
    }

    public synchronized Flyway createFlyway() {
        if (this.flyway == null) {
            this.logger.info((Object)"Create a new flyway instance.");
            Flyway toReturn = new Flyway();
            this.setFlyway(toReturn);
            Properties configuredProperties = this.getFlywayProperties();
            if (configuredProperties == null) {
                configuredProperties = new Properties();
                this.setFlywayProperties(configuredProperties);
                ClassPathResource classPathResource = new ClassPathResource("flyway.properties");
                InputStream inputStream = null;
                try {
                    inputStream = classPathResource.getInputStream();
                    configuredProperties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"Can not load flyway.properties.", (Throwable)e);
                }
                this.logger.info((Object)String.format("Load flyway.properties with %d entries.", configuredProperties.size()));
            } else {
                this.logger.info((Object)String.format("Used preconfigured flyway.properties with %d entries.", configuredProperties.size()));
            }
            toReturn.configure(this.getFlywayProperties());
        }
        return this.flyway;
    }

    public Properties getFlywayProperties() {
        return this.flywayProperties;
    }

    public void setFlywayProperties(Properties flywayProperties) {
        this.flywayProperties = flywayProperties;
    }

    public Flyway getFlyway() {
        return this.flyway;
    }

    private void setFlyway(Flyway flyway) {
        this.flyway = flyway;
    }
}

