/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.internal.messages.MessageSink;
import org.eclipse.jetty.websocket.core.internal.messages.PartialByteArrayMessageSink;
import org.eclipse.jetty.websocket.core.internal.messages.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.core.internal.messages.PartialStringMessageSink;
import org.eclipse.jetty.websocket.core.internal.util.InvokerUtils;
import org.eclipse.jetty.websocket.core.internal.util.ReflectUtils;
import org.eclipse.jetty.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketMessageMetadata;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.UpgradeRequest;
import org.eclipse.jetty.websocket.javax.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.websocket.javax.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedBinaryStreamMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextMessageSink;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedTextStreamMessageSink;

public abstract class JavaxWebSocketFrameHandlerFactory {
    private static final MethodHandle FILTER_RETURN_TYPE_METHOD;
    static final InvokerUtils.Arg[] textPartialCallingArgs;
    static final InvokerUtils.Arg[] binaryPartialBufferCallingArgs;
    static final InvokerUtils.Arg[] binaryPartialArrayCallingArgs;
    static final InvokerUtils.Arg[] pongCallingArgs;
    protected final JavaxWebSocketContainer container;
    protected final InvokerUtils.ParamIdentifier paramIdentifier;
    protected final WebSocketComponents components;

    static InvokerUtils.Arg[] getArgsFor(Class<?> objectType) {
        return new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(objectType).required()};
    }

    public JavaxWebSocketFrameHandlerFactory(JavaxWebSocketContainer container, InvokerUtils.ParamIdentifier paramIdentifier) {
        this.container = container;
        this.components = container.getWebSocketComponents();
        this.paramIdentifier = paramIdentifier == null ? InvokerUtils.PARAM_IDENTITY : paramIdentifier;
    }

    public abstract JavaxWebSocketFrameHandlerMetadata getMetadata(Class<?> var1, EndpointConfig var2);

    public abstract EndpointConfig newDefaultEndpointConfig(Class<?> var1);

    public JavaxWebSocketFrameHandler newJavaxWebSocketFrameHandler(Object endpointInstance, UpgradeRequest upgradeRequest) {
        EndpointConfig config;
        Object endpoint;
        if (endpointInstance instanceof ConfiguredEndpoint) {
            ConfiguredEndpoint configuredEndpoint = (ConfiguredEndpoint)endpointInstance;
            endpoint = configuredEndpoint.getRawEndpoint();
            config = configuredEndpoint.getConfig();
        } else {
            endpoint = endpointInstance;
            config = this.newDefaultEndpointConfig(endpoint.getClass());
        }
        JavaxWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpoint.getClass(), config);
        if (metadata == null) {
            return null;
        }
        MethodHandle openHandle = metadata.getOpenHandle();
        MethodHandle closeHandle = metadata.getCloseHandle();
        MethodHandle errorHandle = metadata.getErrorHandle();
        MethodHandle pongHandle = metadata.getPongHandle();
        JavaxWebSocketMessageMetadata textMetadata = JavaxWebSocketMessageMetadata.copyOf(metadata.getTextMetadata());
        JavaxWebSocketMessageMetadata binaryMetadata = JavaxWebSocketMessageMetadata.copyOf(metadata.getBinaryMetadata());
        UriTemplatePathSpec templatePathSpec = metadata.getUriTemplatePathSpec();
        if (templatePathSpec != null) {
            String[] namedVariables = templatePathSpec.getVariables();
            Map pathParams = templatePathSpec.getPathParams(upgradeRequest.getPathInContext());
            openHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(openHandle, namedVariables, pathParams);
            closeHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(closeHandle, namedVariables, pathParams);
            errorHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(errorHandle, namedVariables, pathParams);
            pongHandle = JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(pongHandle, namedVariables, pathParams);
            if (textMetadata != null) {
                textMetadata.setMethodHandle(JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(textMetadata.getMethodHandle(), namedVariables, pathParams));
            }
            if (binaryMetadata != null) {
                binaryMetadata.setMethodHandle(JavaxWebSocketFrameHandlerFactory.bindTemplateVariables(binaryMetadata.getMethodHandle(), namedVariables, pathParams));
            }
        }
        openHandle = InvokerUtils.bindTo((MethodHandle)openHandle, (Object[])new Object[]{endpoint});
        closeHandle = InvokerUtils.bindTo((MethodHandle)closeHandle, (Object[])new Object[]{endpoint});
        errorHandle = InvokerUtils.bindTo((MethodHandle)errorHandle, (Object[])new Object[]{endpoint});
        pongHandle = InvokerUtils.bindTo((MethodHandle)pongHandle, (Object[])new Object[]{endpoint});
        this.components.getObjectFactory().decorate(endpoint);
        return new JavaxWebSocketFrameHandler(this.container, upgradeRequest, endpoint, openHandle, closeHandle, errorHandle, textMetadata, binaryMetadata, pongHandle, config);
    }

    public static MessageSink createMessageSink(JavaxWebSocketSession session, JavaxWebSocketMessageMetadata msgMetadata) {
        if (msgMetadata == null) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = JavaxWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
            if (AbstractDecodedMessageSink.class.isAssignableFrom(msgMetadata.getSinkClass())) {
                MethodHandle ctorHandle = lookup.findConstructor(msgMetadata.getSinkClass(), MethodType.methodType(Void.TYPE, CoreSession.class, MethodHandle.class, List.class));
                List<RegisteredDecoder> registeredDecoders = msgMetadata.getRegisteredDecoders();
                return ctorHandle.invoke(session.getCoreSession(), msgMetadata.getMethodHandle(), registeredDecoders);
            }
            MethodHandle ctorHandle = lookup.findConstructor(msgMetadata.getSinkClass(), MethodType.methodType(Void.TYPE, CoreSession.class, MethodHandle.class));
            return ctorHandle.invoke(session.getCoreSession(), msgMetadata.getMethodHandle());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing expected MessageSink constructor found at: " + msgMetadata.getSinkClass().getName(), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create MessageSink: " + msgMetadata.getSinkClass().getName(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static MethodHandle wrapNonVoidReturnType(MethodHandle handle, JavaxWebSocketSession session) {
        if (handle == null) {
            return null;
        }
        if (handle.type().returnType() == Void.TYPE) {
            return handle;
        }
        handle = handle.asType(handle.type().changeReturnType(Object.class));
        handle = MethodHandles.filterReturnValue(handle, FILTER_RETURN_TYPE_METHOD.bindTo(session));
        return handle;
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + method, e);
        }
    }

    protected JavaxWebSocketFrameHandlerMetadata createEndpointMetadata(EndpointConfig endpointConfig) {
        JavaxWebSocketFrameHandlerMetadata metadata = new JavaxWebSocketFrameHandlerMetadata(endpointConfig, this.container.getWebSocketComponents());
        MethodHandles.Lookup lookup = JavaxWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
        Method openMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onOpen", (Class[])new Class[]{Session.class, EndpointConfig.class});
        MethodHandle open = this.toMethodHandle(lookup, openMethod);
        metadata.setOpenHandler(open, openMethod);
        Method closeMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onClose", (Class[])new Class[]{Session.class, CloseReason.class});
        MethodHandle close = this.toMethodHandle(lookup, closeMethod);
        metadata.setCloseHandler(close, closeMethod);
        Method errorMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onError", (Class[])new Class[]{Session.class, Throwable.class});
        MethodHandle error = this.toMethodHandle(lookup, errorMethod);
        metadata.setErrorHandler(error, errorMethod);
        return metadata;
    }

    protected JavaxWebSocketFrameHandlerMetadata discoverJavaxFrameHandlerMetadata(Class<?> endpointClass, JavaxWebSocketFrameHandlerMetadata metadata) {
        Method[] onMessages;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        MethodHandles.Lookup lookup = JavaxWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnOpen.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnOpen.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg ENDPOINT_CONFIG = new InvokerUtils.Arg(EndpointConfig.class);
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, ENDPOINT_CONFIG});
            metadata.setOpenHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CLOSE_REASON = new InvokerUtils.Arg(CloseReason.class);
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, CLOSE_REASON});
            metadata.setCloseHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, CAUSE});
            metadata.setErrorHandler(methodHandle, onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnMessage.class)) != null && onMessages.length > 0) {
            for (Method onMsg : onMessages) {
                Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle;
                this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                OnMessage onMessageAnno = onMsg.getAnnotation(OnMessage.class);
                long annotationMaxMessageSize = onMessageAnno.maxMessageSize();
                if (annotationMaxMessageSize > Integer.MAX_VALUE) {
                    throw new InvalidWebSocketException(String.format("Value too large: %s#%s - @OnMessage.maxMessageSize=%,d > Integer.MAX_VALUE", endpointClass.getName(), onMsg.getName(), annotationMaxMessageSize));
                }
                JavaxWebSocketMessageMetadata msgMetadata = new JavaxWebSocketMessageMetadata();
                if (annotationMaxMessageSize != -1L) {
                    msgMetadata.setMaxMessageSize((int)annotationMaxMessageSize);
                }
                if (this.matchDecoders(onMsg, metadata, msgMetadata, getMethodHandle = signature -> InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, (Class)endpointClass, (Method)onMsg, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])signature)) || this.matchOnMessage(onMsg, metadata, msgMetadata, getMethodHandle)) continue;
                throw InvalidSignatureException.build(endpointClass, OnMessage.class, (Method)onMsg);
            }
        }
        return metadata;
    }

    private boolean matchOnMessage(Method onMsg, JavaxWebSocketFrameHandlerMetadata metadata, JavaxWebSocketMessageMetadata msgMetadata, Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle) {
        MethodHandle methodHandle = getMethodHandle.apply(textPartialCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialStringMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setTextMetadata(msgMetadata, onMsg);
            return true;
        }
        methodHandle = getMethodHandle.apply(binaryPartialBufferCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialByteBufferMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
            return true;
        }
        methodHandle = getMethodHandle.apply(binaryPartialArrayCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialByteArrayMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
            return true;
        }
        MethodHandle pongHandle = getMethodHandle.apply(pongCallingArgs);
        if (pongHandle != null) {
            metadata.setPongHandle(pongHandle, onMsg);
            return true;
        }
        return false;
    }

    private boolean matchDecoders(Method onMsg, JavaxWebSocketFrameHandlerMetadata metadata, JavaxWebSocketMessageMetadata msgMetadata, Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle) {
        RegisteredDecoder firstDecoder = metadata.getAvailableDecoders().stream().filter(registeredDecoder -> getMethodHandle.apply(JavaxWebSocketFrameHandlerFactory.getArgsFor(registeredDecoder.objectType)) != null).findFirst().orElse(null);
        if (firstDecoder == null) {
            return false;
        }
        ArrayList<RegisteredDecoder> decoders = new ArrayList<RegisteredDecoder>();
        Class<? extends Decoder> interfaceType = firstDecoder.interfaceType;
        metadata.getAvailableDecoders().stream().filter(decoder -> decoder.interfaceType.equals(interfaceType) && getMethodHandle.apply(JavaxWebSocketFrameHandlerFactory.getArgsFor(decoder.objectType)) != null).forEach(decoders::add);
        msgMetadata.setRegisteredDecoders(decoders);
        Class<?> objectType = firstDecoder.objectType;
        for (RegisteredDecoder decoder2 : decoders) {
            if (!decoder2.objectType.isAssignableFrom(objectType)) continue;
            objectType = decoder2.objectType;
        }
        MethodHandle methodHandle = getMethodHandle.apply(JavaxWebSocketFrameHandlerFactory.getArgsFor(objectType));
        msgMetadata.setMethodHandle(methodHandle);
        if (interfaceType.equals(Decoder.Text.class)) {
            msgMetadata.setSinkClass(DecodedTextMessageSink.class);
            metadata.setTextMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.Binary.class)) {
            msgMetadata.setSinkClass(DecodedBinaryMessageSink.class);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.TextStream.class)) {
            msgMetadata.setSinkClass(DecodedTextStreamMessageSink.class);
            metadata.setTextMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.BinaryStream.class)) {
            msgMetadata.setSinkClass(DecodedBinaryStreamMessageSink.class);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
        }
        return true;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        if (!OnMessage.class.isAssignableFrom(annotationClass)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" return must be void: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
    }

    public static MethodHandle bindTemplateVariables(MethodHandle target, String[] namedVariables, Map<String, String> templateValues) {
        if (target == null) {
            return null;
        }
        boolean IDX = true;
        MethodHandle retHandle = target;
        if (templateValues == null || templateValues.isEmpty()) {
            return retHandle;
        }
        for (String variableName : namedVariables) {
            String strValue = templateValues.get(variableName);
            TypeDescriptor.OfField type = retHandle.type().parameterType(1);
            try {
                if (String.class.isAssignableFrom((Class<?>)type)) {
                    retHandle = MethodHandles.insertArguments(retHandle, 1, strValue);
                    continue;
                }
                if (Integer.class.isAssignableFrom((Class<?>)type) || Integer.TYPE.isAssignableFrom((Class<?>)type)) {
                    Integer intValue = Integer.parseInt(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, intValue);
                    continue;
                }
                if (Long.class.isAssignableFrom((Class<?>)type) || Long.TYPE.isAssignableFrom((Class<?>)type)) {
                    Long longValue = Long.parseLong(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, longValue);
                    continue;
                }
                if (Short.class.isAssignableFrom((Class<?>)type) || Short.TYPE.isAssignableFrom((Class<?>)type)) {
                    Short shortValue = Short.parseShort(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, shortValue);
                    continue;
                }
                if (Float.class.isAssignableFrom((Class<?>)type) || Float.TYPE.isAssignableFrom((Class<?>)type)) {
                    Float floatValue = Float.valueOf(Float.parseFloat(strValue));
                    retHandle = MethodHandles.insertArguments(retHandle, 1, floatValue);
                    continue;
                }
                if (Double.class.isAssignableFrom((Class<?>)type) || Double.TYPE.isAssignableFrom((Class<?>)type)) {
                    Double doubleValue = Double.parseDouble(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, doubleValue);
                    continue;
                }
                if (Boolean.class.isAssignableFrom((Class<?>)type) || Boolean.TYPE.isAssignableFrom((Class<?>)type)) {
                    Boolean boolValue = Boolean.parseBoolean(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, boolValue);
                    continue;
                }
                if (Character.class.isAssignableFrom((Class<?>)type) || Character.TYPE.isAssignableFrom((Class<?>)type)) {
                    if (strValue.length() != 1) {
                        throw new IllegalArgumentException("Invalid Size");
                    }
                    Character charValue = Character.valueOf(strValue.charAt(0));
                    retHandle = MethodHandles.insertArguments(retHandle, 1, charValue);
                    continue;
                }
                if (Byte.class.isAssignableFrom((Class<?>)type) || Byte.TYPE.isAssignableFrom((Class<?>)type)) {
                    Byte b = Byte.parseByte(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, b);
                    continue;
                }
                throw new IllegalStateException("Unsupported Type: " + (Class)type);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage());
            }
        }
        return retHandle;
    }

    public static MethodHandles.Lookup getServerMethodHandleLookup() {
        return MethodHandles.lookup();
    }

    public static MethodHandles.Lookup getApplicationMethodHandleLookup(Class<?> lookupClass) {
        return MethodHandles.publicLookup().in(lookupClass);
    }

    static {
        try {
            FILTER_RETURN_TYPE_METHOD = JavaxWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(JavaxWebSocketSession.class, "filterReturnType", MethodType.methodType(Void.TYPE, Object.class));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        textPartialCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        binaryPartialBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        binaryPartialArrayCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(byte[].class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        pongCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(PongMessage.class).required()};
    }
}

