/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class QueuedHttpInput<T>
extends HttpInput<T> {
    private static final Logger LOG = Log.getLogger(QueuedHttpInput.class);
    private final ArrayQueue<T> _inputQ = new ArrayQueue(this.lock());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            Object item = this._inputQ.peekUnsafe();
            while (item != null) {
                this._inputQ.pollUnsafe();
                this.onContentConsumed(item);
                item = this._inputQ.peekUnsafe();
                if (item != null) continue;
                this.onAllContentConsumed();
            }
            super.recycle();
        }
    }

    @Override
    protected T nextContent() {
        Object item = this._inputQ.peekUnsafe();
        while (item != null && this.remaining(item) == 0) {
            this._inputQ.pollUnsafe();
            this.onContentConsumed(item);
            LOG.debug("{} consumed {}", new Object[]{this, item});
            item = this._inputQ.peekUnsafe();
            if (item != null) continue;
            this.onAllContentConsumed();
        }
        return (T)item;
    }

    protected abstract void onContentConsumed(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockForContent() throws IOException {
        Object object = this.lock();
        synchronized (object) {
            while (this._inputQ.isEmpty() && !this._state.isEOF()) {
                try {
                    LOG.debug("{} waiting for content", new Object[]{this});
                    this.lock().wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
    }

    protected void onAllContentConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void content(T item) {
        Object object = this.lock();
        synchronized (object) {
            boolean empty = this._inputQ.isEmpty();
            this._inputQ.add(item);
            if (empty && !this.onAsyncRead()) {
                this.lock().notify();
            }
            LOG.debug("{} queued {}", new Object[]{this, item});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            super.earlyEOF();
            this.lock().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageComplete() {
        Object object = this.lock();
        synchronized (object) {
            super.messageComplete();
            this.lock().notify();
        }
    }
}

