/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class HttpOutput
extends ServletOutputStream {
    private static final boolean OUTPUT_BUFFER_DIRECT = false;
    private static final boolean CHANNEL_BUFFER_DIRECT = true;
    private static final boolean STREAM_BUFFER_DIRECT = false;
    private static Logger LOG = Log.getLogger(HttpOutput.class);
    private final HttpChannel<?> _channel;
    private boolean _closed;
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;

    public HttpOutput(HttpChannel<?> channel) {
        this._channel = channel;
        this._bufferSize = this._channel.getHttpConfiguration().getOutputBufferSize();
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reset() {
        this._written = 0L;
        this._closed = false;
    }

    public void reopen() {
        this._closed = false;
    }

    void closed() {
        this._closed = true;
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public void close() {
        if (!this._closed) {
            try {
                if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                    this._channel.write(this._aggregate, !this._channel.getResponse().isIncluding());
                } else {
                    this._channel.write(BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
                }
            }
            catch (IOException e) {
                this._channel.getEndPoint().shutdownOutput();
                LOG.ignore((Throwable)e);
            }
        }
        this._closed = true;
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new EofException();
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        } else {
            this._channel.write(BufferUtil.EMPTY_BUFFER, false);
        }
    }

    public boolean closeIfAllContentWritten() throws IOException {
        return this._channel.getResponse().closeIfAllContentWritten(this._written);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int space;
        if (this._closed) {
            throw new EOFException();
        }
        if (this._aggregate == null) {
            int size = this.getBufferSize();
            if (len > size / 2) {
                this._channel.write(ByteBuffer.wrap(b, off, len), false);
                this._written += (long)len;
                return;
            }
            this._aggregate = this._channel.getByteBufferPool().acquire(size, false);
        }
        if (len > (space = BufferUtil.space((ByteBuffer)this._aggregate)) && BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
            space = BufferUtil.space((ByteBuffer)this._aggregate);
        }
        if (len > space) {
            this._channel.write(ByteBuffer.wrap(b, off, len), false);
            this._written += (long)len;
            return;
        }
        BufferUtil.append((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
        this._written += (long)len;
        if (!this.closeIfAllContentWritten() && BufferUtil.isFull((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        }
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new EOFException();
        }
        if (this._aggregate == null) {
            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
        }
        BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
        ++this._written;
        if (!this.closeIfAllContentWritten() && BufferUtil.isFull((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        }
    }

    public void print(String s) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(s.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContent(Object content) throws IOException {
        block28: {
            ByteBuffer buffer;
            if (this.isClosed()) {
                throw new IOException("Closed");
            }
            if (content instanceof HttpContent) {
                long lml;
                String lm;
                HttpContent httpContent = (HttpContent)content;
                Response response = this._channel.getResponse();
                String contentType = httpContent.getContentType();
                if (contentType != null && !response.getHttpFields().containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                    response.getHttpFields().put(HttpHeader.CONTENT_TYPE, contentType);
                }
                if (httpContent.getContentLength() > 0L) {
                    response.getHttpFields().putLongField(HttpHeader.CONTENT_LENGTH, httpContent.getContentLength());
                }
                if ((lm = httpContent.getLastModified()) != null) {
                    response.getHttpFields().put(HttpHeader.LAST_MODIFIED, lm);
                } else if (httpContent.getResource() != null && (lml = httpContent.getResource().lastModified()) != -1L) {
                    response.getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, lml);
                }
                String etag = httpContent.getETag();
                if (etag != null) {
                    response.getHttpFields().put(HttpHeader.ETAG, etag);
                }
                if ((content = httpContent.getDirectBuffer()) == null) {
                    content = httpContent.getIndirectBuffer();
                }
                if (content == null) {
                    content = httpContent.getReadableByteChannel();
                }
                if (content == null) {
                    content = httpContent.getInputStream();
                }
            } else if (content instanceof Resource) {
                Resource resource = (Resource)content;
                this._channel.getResponse().getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, resource.lastModified());
                content = resource.getInputStream();
            }
            if (content instanceof ByteBuffer) {
                this._channel.write((ByteBuffer)content, true);
                this._closed = true;
            } else if (content instanceof ReadableByteChannel) {
                ReadableByteChannel channel = (ReadableByteChannel)content;
                buffer = this._channel.getByteBufferPool().acquire(this.getBufferSize(), true);
                try {
                    while (channel.isOpen()) {
                        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
                        int len = channel.read(buffer);
                        if (len < 0) {
                        }
                        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
                        this._channel.write(buffer, false);
                    }
                }
                finally {
                    this.close();
                    this._channel.getByteBufferPool().release(buffer);
                }
            } else {
                if (content instanceof InputStream) {
                    InputStream in = (InputStream)content;
                    buffer = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
                    byte[] array = buffer.array();
                    int offset = buffer.arrayOffset();
                    int size = array.length - offset;
                    try {
                        while (true) {
                            int len;
                            if ((len = in.read(array, offset, size)) < 0) {
                                break block28;
                            }
                            buffer.position(0);
                            buffer.limit(len);
                            this._channel.write(buffer, false);
                        }
                    }
                    finally {
                        this.close();
                        this._channel.getByteBufferPool().release(buffer);
                    }
                }
                throw new IllegalArgumentException("unknown content type " + content.getClass());
            }
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void resetBuffer() {
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            BufferUtil.clear((ByteBuffer)this._aggregate);
        }
    }
}

