/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ForkInvoker;
import org.eclipse.jetty.util.log.Logger;

public abstract class ProxyConnection
extends AbstractConnection {
    protected static final Logger LOG = ConnectHandler.LOG;
    private final ForkInvoker<ByteBuffer> invoker = new ProxyForkInvoker();
    private final ByteBufferPool bufferPool;
    private final ConcurrentMap<String, Object> context;
    private Connection connection;

    protected ProxyConnection(EndPoint endp, Executor executor, ByteBufferPool bufferPool, ConcurrentMap<String, Object> context) {
        super(endp, executor);
        this.bufferPool = bufferPool;
        this.context = context;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public ConcurrentMap<String, Object> getContext() {
        return this.context;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void onFillable() {
        ByteBuffer buffer = this.getByteBufferPool().acquire(this.getInputBufferSize(), true);
        this.fill(buffer);
    }

    private void fill(final ByteBuffer buffer) {
        try {
            final int filled = this.read(this.getEndPoint(), buffer, this.getContext());
            LOG.debug("{} filled {} bytes", new Object[]{this, filled});
            if (filled > 0) {
                this.write(this.getConnection().getEndPoint(), buffer, this.getContext(), new Callback<Void>(){

                    public void completed(Void context) {
                        LOG.debug("{} wrote {} bytes", new Object[]{this, filled});
                        buffer.clear();
                        ProxyConnection.this.invoker.invoke((Object)buffer);
                    }

                    public void failed(Void context, Throwable x) {
                        LOG.debug(this + " failed to write " + filled + " bytes", x);
                        ProxyConnection.this.bufferPool.release(buffer);
                        ProxyConnection.this.connection.close();
                    }
                });
            } else if (filled == 0) {
                this.bufferPool.release(buffer);
                this.fillInterested();
            } else {
                this.bufferPool.release(buffer);
                this.connection.getEndPoint().shutdownOutput();
            }
        }
        catch (IOException x) {
            LOG.debug((Object)((Object)this) + " could not fill", (Throwable)x);
            this.bufferPool.release(buffer);
            this.close();
            this.connection.close();
        }
    }

    protected abstract int read(EndPoint var1, ByteBuffer var2, ConcurrentMap<String, Object> var3) throws IOException;

    protected abstract void write(EndPoint var1, ByteBuffer var2, ConcurrentMap<String, Object> var3, Callback<Void> var4);

    public String toString() {
        return String.format("%s[l:%d<=>r:%d]", super.toString(), this.getEndPoint().getLocalAddress().getPort(), this.getEndPoint().getRemoteAddress().getPort());
    }

    private class ProxyForkInvoker
    extends ForkInvoker<ByteBuffer> {
        private ProxyForkInvoker() {
            super(4);
        }

        public void fork(final ByteBuffer buffer) {
            ProxyConnection.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ProxyForkInvoker.this.call(buffer);
                }
            });
        }

        public void call(ByteBuffer buffer) {
            ProxyConnection.this.fill(buffer);
        }
    }
}

