/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowSymLinkAliasChecker.class);

    @Override
    public boolean check(String uri, Resource resource) {
        if (!(resource instanceof PathResource)) {
            return false;
        }
        PathResource pathResource = (PathResource)resource;
        try {
            Path path = pathResource.getPath();
            if (Files.isSymbolicLink(path) && Files.isSameFile(path, pathResource.getAliasPath())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow symlink {} --> {}", resource, pathResource.getAliasPath());
                }
                return true;
            }
            Path d = path.getRoot();
            for (Path e : path) {
                d = d.resolve(e);
                while (Files.exists(d, new LinkOption[0]) && Files.isSymbolicLink(d)) {
                    Path link = Files.readSymbolicLink(d);
                    if (!link.isAbsolute()) {
                        link = d.resolve(link);
                    }
                    d = link;
                }
            }
            if (pathResource.getAliasPath().equals(d)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Allow path symlink {} --> {}", resource, d);
                }
                return true;
            }
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        return false;
    }
}

