/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.runner;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ConnectorStatistics;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;

public class Runner {
    private static final Logger LOG = Log.getLogger(Runner.class);
    public static final String[] __plusConfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName()};
    public static final String __containerIncludeJarPattern = ".*/jetty-runner-[^/]*\\.jar$";
    public static final String __defaultContextPath = "/";
    public static final int __defaultPort = 8080;
    protected Server _server;
    protected URLClassLoader _classLoader;
    protected Classpath _classpath = new Classpath();
    protected ContextHandlerCollection _contexts;
    protected RequestLogHandler _logHandler;
    protected String _logFile;
    protected ArrayList<String> _configFiles;
    protected boolean _enableStats = false;
    protected String _statsPropFile;

    public void usage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("Usage: java [-Djetty.home=dir] -jar jetty-runner.jar [--help|--version] [ server opts] [[ context opts] context ...] ");
        System.err.println("Server opts:");
        System.err.println(" --version                           - display version and exit");
        System.err.println(" --log file                          - request log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --out file                          - info/warn/debug log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --host name|ip                      - interface to listen on (default is all interfaces)");
        System.err.println(" --port n                            - port to listen on (default 8080)");
        System.err.println(" --stop-port n                       - port to listen for stop command");
        System.err.println(" --stop-key n                        - security string for stop command (required if --stop-port is present)");
        System.err.println(" [--jar file]*n                      - each tuple specifies an extra jar to be added to the classloader");
        System.err.println(" [--lib dir]*n                       - each tuple specifies an extra directory of jars to be added to the classloader");
        System.err.println(" [--classes dir]*n                   - each tuple specifies an extra directory of classes to be added to the classloader");
        System.err.println(" --stats [unsecure|realm.properties] - enable stats gathering servlet context");
        System.err.println(" [--config file]*n                   - each tuple specifies the name of a jetty xml config file to apply (in the order defined)");
        System.err.println("Context opts:");
        System.err.println(" [[--path /path] context]*n          - WAR file, web app dir or context xml file, optionally with a context path");
        System.exit(1);
    }

    public void version() {
        System.err.println("org.eclipse.jetty.runner.Runner: " + Server.getVersion());
        System.exit(1);
    }

    public void configure(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            Throwable throwable;
            if ("--lib".equals(args[i])) {
                throwable = null;
                try (Resource lib = Resource.newResource(args[++i]);){
                    if (!lib.exists() || !lib.isDirectory()) {
                        this.usage("No such lib directory " + lib);
                    }
                    this._classpath.addJars(lib);
                    continue;
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            if ("--jar".equals(args[i])) {
                throwable = null;
                try (Resource jar = Resource.newResource(args[++i]);){
                    if (!jar.exists() || jar.isDirectory()) {
                        this.usage("No such jar " + jar);
                    }
                    this._classpath.addPath(jar);
                    continue;
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            if ("--classes".equals(args[i])) {
                throwable = null;
                try (Resource classes = Resource.newResource(args[++i]);){
                    if (!classes.exists() || !classes.isDirectory()) {
                        this.usage("No such classes directory " + classes);
                    }
                    this._classpath.addPath(classes);
                    continue;
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            if (!args[i].startsWith("--")) continue;
            ++i;
        }
        this.initClassLoader();
        LOG.info("Runner", new Object[0]);
        LOG.debug("Runner classpath {}", this._classpath);
        String contextPath = __defaultContextPath;
        boolean contextPathSet = false;
        int port = 8080;
        String host = null;
        int stopPort = 0;
        String stopKey = null;
        boolean runnerServerInitialized = false;
        block79: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--port": {
                    port = Integer.parseInt(args[++i]);
                    continue block79;
                }
                case "--host": {
                    host = args[++i];
                    continue block79;
                }
                case "--stop-port": {
                    stopPort = Integer.parseInt(args[++i]);
                    continue block79;
                }
                case "--stop-key": {
                    stopKey = args[++i];
                    continue block79;
                }
                case "--log": {
                    this._logFile = args[++i];
                    continue block79;
                }
                case "--out": {
                    String outFile = args[++i];
                    PrintStream out = new PrintStream(new RolloverFileOutputStream(outFile, true, -1));
                    LOG.info("Redirecting stderr/stdout to " + outFile, new Object[0]);
                    System.setErr(out);
                    System.setOut(out);
                    continue block79;
                }
                case "--path": {
                    contextPath = args[++i];
                    contextPathSet = true;
                    continue block79;
                }
                case "--config": {
                    if (this._configFiles == null) {
                        this._configFiles = new ArrayList();
                    }
                    this._configFiles.add(args[++i]);
                    continue block79;
                }
                case "--lib": {
                    ++i;
                    continue block79;
                }
                case "--jar": {
                    ++i;
                    continue block79;
                }
                case "--classes": {
                    ++i;
                    continue block79;
                }
                case "--stats": {
                    this._enableStats = true;
                    this._statsPropFile = args[++i];
                    this._statsPropFile = "unsecure".equalsIgnoreCase(this._statsPropFile) ? null : this._statsPropFile;
                    continue block79;
                }
                default: {
                    if (!runnerServerInitialized) {
                        Connector[] connectors;
                        HandlerCollection handlers;
                        if (this._server == null) {
                            this._server = new Server();
                        }
                        if (this._configFiles != null) {
                            for (String cfg : this._configFiles) {
                                Resource resource = Resource.newResource(cfg);
                                Throwable throwable = null;
                                try {
                                    XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.getURL());
                                    xmlConfiguration.configure(this._server);
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                                finally {
                                    if (resource == null) continue;
                                    if (throwable != null) {
                                        try {
                                            resource.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                        continue;
                                    }
                                    resource.close();
                                }
                            }
                        }
                        if ((handlers = this._server.getChildHandlerByClass(HandlerCollection.class)) == null) {
                            handlers = new HandlerCollection();
                            this._server.setHandler(handlers);
                        }
                        this._contexts = handlers.getChildHandlerByClass(ContextHandlerCollection.class);
                        if (this._contexts == null) {
                            this._contexts = new ContextHandlerCollection();
                            this.prependHandler(this._contexts, handlers);
                        }
                        if (this._enableStats && handlers.getChildHandlerByClass(StatisticsHandler.class) == null) {
                            StatisticsHandler statsHandler = new StatisticsHandler();
                            Handler oldHandler = this._server.getHandler();
                            statsHandler.setHandler(oldHandler);
                            this._server.setHandler(statsHandler);
                            ServletContextHandler statsContext = new ServletContextHandler(this._contexts, "/stats");
                            statsContext.addServlet(new ServletHolder(new StatisticsServlet()), __defaultContextPath);
                            statsContext.setSessionHandler(new SessionHandler());
                            if (this._statsPropFile != null) {
                                HashLoginService loginService = new HashLoginService("StatsRealm", this._statsPropFile);
                                Constraint constraint = new Constraint();
                                constraint.setName("Admin Only");
                                constraint.setRoles(new String[]{"admin"});
                                constraint.setAuthenticate(true);
                                ConstraintMapping cm = new ConstraintMapping();
                                cm.setConstraint(constraint);
                                cm.setPathSpec("/*");
                                ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                                securityHandler.setLoginService(loginService);
                                securityHandler.setConstraintMappings(Collections.singletonList(cm));
                                securityHandler.setAuthenticator(new BasicAuthenticator());
                                statsContext.setSecurityHandler(securityHandler);
                            }
                        }
                        if (handlers.getChildHandlerByClass(DefaultHandler.class) == null) {
                            handlers.addHandler(new DefaultHandler());
                        }
                        this._logHandler = handlers.getChildHandlerByClass(RequestLogHandler.class);
                        if (this._logHandler == null) {
                            this._logHandler = new RequestLogHandler();
                            handlers.addHandler(this._logHandler);
                        }
                        if ((connectors = this._server.getConnectors()) == null || connectors.length == 0) {
                            ServerConnector connector = new ServerConnector(this._server);
                            connector.setPort(port);
                            if (host != null) {
                                connector.setHost(host);
                            }
                            this._server.addConnector(connector);
                            if (this._enableStats) {
                                connector.addBean(new ConnectorStatistics());
                            }
                        } else if (this._enableStats) {
                            for (Connector connector : connectors) {
                                ((AbstractConnector)connector).addBean(new ConnectorStatistics());
                            }
                        }
                        runnerServerInitialized = true;
                    }
                    try (Resource ctx = Resource.newResource(args[i]);){
                        if (!ctx.exists()) {
                            this.usage("Context '" + ctx + "' does not exist");
                        }
                        if (contextPathSet && !contextPath.startsWith(__defaultContextPath)) {
                            contextPath = __defaultContextPath + contextPath;
                        }
                        if (!ctx.isDirectory() && ctx.toString().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                            XmlConfiguration xmlConfiguration = new XmlConfiguration(ctx.getURL());
                            xmlConfiguration.getIdMap().put("Server", this._server);
                            ContextHandler handler = (ContextHandler)xmlConfiguration.configure();
                            if (contextPathSet) {
                                handler.setContextPath(contextPath);
                            }
                            this._contexts.addHandler(handler);
                            handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", __containerIncludeJarPattern);
                        } else {
                            WebAppContext webapp = new WebAppContext((HandlerContainer)this._contexts, ctx.toString(), contextPath);
                            webapp.setConfigurationClasses(__plusConfigurationClasses);
                            webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", __containerIncludeJarPattern);
                        }
                    }
                    contextPathSet = false;
                    contextPath = __defaultContextPath;
                }
            }
        }
        if (this._server == null) {
            this.usage("No Contexts defined");
        }
        this._server.setStopAtShutdown(true);
        switch ((stopPort > 0 ? 1 : 0) + (stopKey != null ? 2 : 0)) {
            case 1: {
                this.usage("Must specify --stop-key when --stop-port is specified");
                break;
            }
            case 2: {
                this.usage("Must specify --stop-port when --stop-key is specified");
                break;
            }
            case 3: {
                ShutdownMonitor monitor = ShutdownMonitor.getInstance();
                monitor.setPort(stopPort);
                monitor.setKey(stopKey);
                monitor.setExitVm(true);
            }
        }
        if (this._logFile != null) {
            NCSARequestLog requestLog = new NCSARequestLog(this._logFile);
            requestLog.setExtended(false);
            this._logHandler.setRequestLog(requestLog);
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    public void run() throws Exception {
        this._server.start();
        this._server.join();
    }

    protected void initClassLoader() {
        URL[] paths = this._classpath.asArray();
        if (this._classLoader == null && paths != null && paths.length > 0) {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            this._classLoader = context == null ? new URLClassLoader(paths) : new URLClassLoader(paths, context);
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
    }

    public static void main(String[] args) {
        Runner runner = new Runner();
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                runner.usage(null);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                runner.version();
            } else {
                runner.configure(args);
                runner.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            runner.usage(null);
        }
    }

    public class Classpath {
        private List<URL> _classpath = new ArrayList<URL>();

        public void addJars(Resource lib) throws IOException {
            if (lib == null || !lib.exists()) {
                throw new IllegalStateException("No such lib: " + lib);
            }
            String[] list = lib.list();
            if (list == null) {
                return;
            }
            for (String path : list) {
                if (".".equals(path) || "..".equals(path)) continue;
                try (Resource item = lib.addPath(path);){
                    if (item.isDirectory()) {
                        this.addJars(item);
                        continue;
                    }
                    String lowerCasePath = path.toLowerCase(Locale.ENGLISH);
                    if (!lowerCasePath.endsWith(".jar") && !lowerCasePath.endsWith(".zip")) continue;
                    URL url = item.getURL();
                    this._classpath.add(url);
                }
            }
        }

        public void addPath(Resource path) {
            if (path == null || !path.exists()) {
                throw new IllegalStateException("No such path: " + path);
            }
            this._classpath.add(path.getURL());
        }

        public URL[] asArray() {
            return this._classpath.toArray(new URL[this._classpath.size()]);
        }
    }
}

