/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.EventListener;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.util.PathWatcher;

@Mojo(name="run-war", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class JettyRunWarMojo
extends AbstractJettyMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.war", required=true)
    private File war;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webApp.setWar(this.war.getCanonicalPath());
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        this.scanner.watch(this.project.getFile().toPath());
        this.scanner.watch(this.war.toPath());
        this.scanner.addListener((EventListener)new PathWatcher.EventListListener(){

            public void onPathWatchEvents(List<PathWatcher.PathWatchEvent> events) {
                try {
                    boolean reconfigure = false;
                    for (PathWatcher.PathWatchEvent e : events) {
                        if (!e.getPath().equals(JettyRunWarMojo.this.project.getFile().toPath())) continue;
                        reconfigure = true;
                        break;
                    }
                    JettyRunWarMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunWarMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp ...");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.stopScanner();
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanner.reset();
            this.configureScanner();
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.startScanner();
        this.getLog().info((CharSequence)"Restart completed.");
    }
}

