/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.mortbay.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.mortbay.io.nio.MAX_SELECTS", 15000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.mortbay.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.mortbay.io.nio.BUSY_KEY", -1);
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public void register(SocketChannel channel, Object att) {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1);

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (SelectSet set : sets) {
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract void endPointUpgraded(ConnectedEndPoint var1, Connection var2);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn((String)(ex + "," + channel + "," + attachment));
        Log.debug((Throwable)ex);
    }

    public void dump() {
        for (final SelectSet set : this._selectSet) {
            StackTraceElement[] trace;
            Thread selecting = set._selecting;
            Log.info((String)("SelectSet " + set._setID + " : " + selecting));
            if (selecting != null && (trace = selecting.getStackTrace()) != null) {
                for (StackTraceElement e : trace) {
                    Log.info((String)("\tat " + e.toString()));
                }
            }
            set.addChange(new ChangeTask(){

                @Override
                public void run() {
                    set.dump();
                }
            });
        }
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private final int _setID;
        private final Timeout _idleTimeout;
        private final Timeout _timeout;
        private final List<Object>[] _changes;
        private int _change;
        private int _nextSet;
        private Selector _selector;
        private volatile Thread _selecting;
        private int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout((Object)this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._timeout = new Timeout((Object)this);
            this._timeout.setDuration(0L);
            this._changes = new List[]{new ArrayList(), new ArrayList()};
            this._selector = Selector.open();
            this._change = 0;
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List<Object>[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChangeSelectableChannel(channel, att));
            }
        }

        public void cancelIdle(Timeout.Task task) {
            task.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doSelect() throws IOException {
            Iterator<SelectionKey> i$;
            Selector new_selector;
            try {
                Selector selector;
                block76: {
                    long now;
                    block70: {
                        block73: {
                            SelectionKey busy;
                            block78: {
                                block77: {
                                    int selected;
                                    block74: {
                                        block71: {
                                            block75: {
                                                Object endpoint;
                                                this._selecting = Thread.currentThread();
                                                List<Object>[] listArray = this._changes;
                                                // MONITORENTER : this._changes
                                                List<Object> changes = this._changes[this._change];
                                                this._change = this._change == 0 ? 1 : 0;
                                                selector = this._selector;
                                                // MONITOREXIT : listArray
                                                int size = changes.size();
                                                for (int i = 0; i < size; ++i) {
                                                    try {
                                                        AbstractSelectableChannel channel;
                                                        Object o = changes.get(i);
                                                        if (o instanceof EndPoint) {
                                                            SelectChannelEndPoint endpoint2 = (SelectChannelEndPoint)o;
                                                            endpoint2.doUpdateKey();
                                                            continue;
                                                        }
                                                        if (o instanceof Runnable) {
                                                            SelectorManager.this.dispatch((Runnable)o);
                                                            continue;
                                                        }
                                                        if (o instanceof ChangeSelectableChannel) {
                                                            ChangeSelectableChannel asc = (ChangeSelectableChannel)o;
                                                            SelectableChannel channel2 = asc._channel;
                                                            Object att = asc._attachment;
                                                            if (channel2 instanceof SocketChannel && ((SocketChannel)channel2).isConnected()) {
                                                                SelectionKey key = channel2.register(selector, 1, att);
                                                                endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel2, this, key);
                                                                key.attach(endpoint);
                                                                ((SelectChannelEndPoint)endpoint).schedule();
                                                                continue;
                                                            }
                                                            if (!channel2.isOpen()) continue;
                                                            channel2.register(selector, 8, att);
                                                            continue;
                                                        }
                                                        if (o instanceof SocketChannel) {
                                                            channel = (SocketChannel)o;
                                                            if (((SocketChannel)channel).isConnected()) {
                                                                SelectionKey key = channel.register(selector, 1, null);
                                                                SelectChannelEndPoint endpoint3 = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                                                key.attach(endpoint3);
                                                                endpoint3.schedule();
                                                                continue;
                                                            }
                                                            if (!channel.isOpen()) continue;
                                                            channel.register(selector, 8, null);
                                                            continue;
                                                        }
                                                        if (o instanceof ServerSocketChannel) {
                                                            channel = (ServerSocketChannel)o;
                                                            channel.register(this.getSelector(), 16);
                                                            continue;
                                                        }
                                                        if (!(o instanceof ChangeTask)) throw new IllegalArgumentException(o.toString());
                                                        ((ChangeTask)o).run();
                                                        continue;
                                                    }
                                                    catch (Exception e) {
                                                        if (SelectorManager.this.isRunning()) {
                                                            Log.warn((Throwable)e);
                                                            continue;
                                                        }
                                                        Log.debug((Throwable)e);
                                                    }
                                                }
                                                changes.clear();
                                                now = System.currentTimeMillis();
                                                endpoint = this;
                                                // MONITORENTER : endpoint
                                                this._idleTimeout.setNow(now);
                                                this._timeout.setNow(now);
                                                if (SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                                                    this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                                                } else {
                                                    this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                                                }
                                                long idle_next = this._idleTimeout.getTimeToNext();
                                                long retry_next = this._timeout.getTimeToNext();
                                                // MONITOREXIT : endpoint
                                                long wait = 1000L;
                                                if (idle_next >= 0L && wait > idle_next) {
                                                    wait = idle_next;
                                                }
                                                if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                                    wait = retry_next;
                                                }
                                                if (wait <= 0L) break block73;
                                                if (this._pausing) {
                                                    try {
                                                        Thread.sleep(__BUSY_PAUSE);
                                                    }
                                                    catch (InterruptedException e) {
                                                        Log.ignore((Throwable)e);
                                                    }
                                                }
                                                long before = now;
                                                selected = selector.select(wait);
                                                now = System.currentTimeMillis();
                                                this._idleTimeout.setNow(now);
                                                this._timeout.setNow(now);
                                                ++this._selects;
                                                if (now > this._monitorNext) {
                                                    this._selects = (int)((long)(this._selects * __MONITOR_PERIOD) / (now - this._monitorStart));
                                                    boolean bl = this._pausing = this._selects > __MAX_SELECTS;
                                                    if (this._pausing) {
                                                        ++this._paused;
                                                    }
                                                    this._selects = 0;
                                                    this._jvmBug = 0;
                                                    this._monitorStart = now;
                                                    this._monitorNext = now + (long)__MONITOR_PERIOD;
                                                }
                                                if (now > this._log) {
                                                    if (this._paused > 0) {
                                                        Log.info((String)(this + " Busy selector - injecting delay " + this._paused + " times"));
                                                    }
                                                    if (this._jvmFix2 > 0) {
                                                        Log.info((String)(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times"));
                                                    }
                                                    if (this._jvmFix1 > 0) {
                                                        Log.info((String)(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, cancelled keys " + this._jvmFix0 + " times"));
                                                    } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                                                        Log.info((String)(this + " JVM BUG(s) - cancelled keys " + this._jvmFix0 + " times"));
                                                    }
                                                    this._paused = 0;
                                                    this._jvmFix2 = 0;
                                                    this._jvmFix1 = 0;
                                                    this._jvmFix0 = 0;
                                                    this._log = now + 60000L;
                                                }
                                                if (selected != 0 || wait <= 10L || now - before >= wait / 2L) break block74;
                                                ++this._jvmBug;
                                                if (this._jvmBug <= __JVMBUG_THRESHHOLD) break block75;
                                                try {
                                                    if (this._jvmBug == __JVMBUG_THRESHHOLD + 1) {
                                                        ++this._jvmFix2;
                                                    }
                                                    Thread.sleep(__BUSY_PAUSE);
                                                }
                                                catch (InterruptedException e) {
                                                    Log.ignore((Throwable)e);
                                                }
                                                break block70;
                                            }
                                            if (this._jvmBug == __JVMBUG_THRESHHOLD) break block76;
                                            {
                                                if (this._jvmBug % 32 != 31) break block70;
                                                int cancelled = 0;
                                                for (SelectionKey k : selector.keys()) {
                                                    if (!k.isValid() || k.interestOps() != 0) continue;
                                                    k.cancel();
                                                    ++cancelled;
                                                }
                                                if (cancelled <= 0) break block71;
                                                ++this._jvmFix0;
                                            }
                                        }
                                        this._selecting = null;
                                        return;
                                    }
                                    if (__BUSY_KEY <= 0 || selected != 1 || this._selects <= __MAX_SELECTS) break block70;
                                    busy = selector.selectedKeys().iterator().next();
                                    if (busy != this._busyKey) break block77;
                                    if (++this._busyKeyCount > __BUSY_KEY && !(busy.channel() instanceof ServerSocketChannel)) {
                                        final SelectChannelEndPoint endpoint = (SelectChannelEndPoint)busy.attachment();
                                        Log.warn((String)("Busy Key " + busy.channel() + " " + endpoint));
                                        busy.cancel();
                                        if (endpoint != null) {
                                            SelectorManager.this.dispatch(new Runnable(){

                                                @Override
                                                public void run() {
                                                    try {
                                                        endpoint.close();
                                                    }
                                                    catch (IOException e) {
                                                        Log.ignore((Throwable)e);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                    break block78;
                                }
                                this._busyKeyCount = 0;
                            }
                            this._busyKey = busy;
                            break block70;
                        }
                        selector.selectNow();
                        ++this._selects;
                    }
                    if (this._selector == null) return;
                    if (!selector.isOpen()) {
                        return;
                    }
                    for (SelectionKey key : selector.selectedKeys()) {
                        try {
                            block80: {
                                SelectChannelEndPoint endpoint;
                                SocketChannel channel;
                                Object att;
                                block81: {
                                    block79: {
                                        if (!key.isValid()) {
                                            key.cancel();
                                            SelectChannelEndPoint endpoint4 = (SelectChannelEndPoint)key.attachment();
                                            if (endpoint4 == null) continue;
                                            endpoint4.doUpdateKey();
                                            continue;
                                        }
                                        att = key.attachment();
                                        if (!(att instanceof SelectChannelEndPoint)) break block79;
                                        ((SelectChannelEndPoint)att).schedule();
                                        break block80;
                                    }
                                    if (!key.isAcceptable()) break block81;
                                    channel = SelectorManager.this.acceptChannel(key);
                                    if (channel == null) continue;
                                    channel.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.this._selectSet.length;
                                    if (this._nextSet == this._setID) {
                                        SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                        endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                        cKey.attach(endpoint);
                                        if (endpoint != null) {
                                            endpoint.schedule();
                                        }
                                        break block80;
                                    } else {
                                        SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                        SelectorManager.this._selectSet[this._nextSet].wakeup();
                                    }
                                    break block80;
                                }
                                if (key.isConnectable()) {
                                    channel = (SocketChannel)key.channel();
                                    boolean connected = false;
                                    try {
                                        connected = channel.finishConnect();
                                    }
                                    catch (Exception e) {
                                        SelectorManager.this.connectionFailed(channel, e, att);
                                    }
                                    finally {
                                        if (connected) {
                                            key.interestOps(1);
                                            endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                            key.attach(endpoint);
                                            endpoint.schedule();
                                        } else {
                                            key.cancel();
                                        }
                                    }
                                } else {
                                    channel = (SocketChannel)key.channel();
                                    SelectChannelEndPoint endpoint5 = SelectorManager.this.newEndPoint(channel, this, key);
                                    key.attach(endpoint5);
                                    if (key.isReadable()) {
                                        endpoint5.schedule();
                                    }
                                }
                            }
                            key = null;
                        }
                        catch (CancelledKeyException e) {
                            Log.ignore((Throwable)e);
                        }
                        catch (Exception e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                            } else {
                                Log.ignore((Throwable)e);
                            }
                            if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                            key.cancel();
                        }
                    }
                    selector.selectedKeys().clear();
                    this._idleTimeout.tick(now);
                    this._timeout.tick(now);
                    return;
                }
                SelectSet e = this;
                // MONITORENTER : e
                new_selector = Selector.open();
                i$ = selector.keys().iterator();
            }
            catch (CancelledKeyException e) {
                Log.ignore((Throwable)e);
                return;
            }
            finally {
                this._selecting = null;
            }
            while (true) {
                if (!i$.hasNext()) {
                    this._selector.close();
                    this._selector = new_selector;
                    // MONITOREXIT : e
                    return;
                }
                SelectionKey k = i$.next();
                if (!k.isValid() || k.interestOps() == 0) continue;
                SelectableChannel channel = k.channel();
                Object attachment = k.attachment();
                if (attachment == null) {
                    this.addChange(channel);
                    continue;
                }
                this.addChange(channel, attachment);
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        public void scheduleIdle(Timeout.Task task) {
            if (this._idleTimeout.getDuration() <= 0L) {
                return;
            }
            this._idleTimeout.schedule(task);
        }

        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            this._timeout.schedule(task, timeoutMs);
        }

        public void cancelTimeout(Timeout.Task task) {
            task.cancel();
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting != null;
            }
            for (SelectionKey key : this._selector.keys()) {
                Object att;
                if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                EndPoint endpoint = (EndPoint)att;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                boolean bl = selecting = this._selecting != null;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting != null;
                }
                this._idleTimeout.cancelAll();
                this._timeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                this._selector = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump() {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                Selector selector = this._selector;
                Log.info((String)("SelectSet " + this._setID + " " + selector.keys().size()));
                for (SelectionKey key : selector.keys()) {
                    if (key.isValid()) {
                        Log.info((String)(key.channel() + " " + key.interestOps() + " " + key.readyOps() + " " + key.attachment()));
                        continue;
                    }
                    Log.info((String)(key.channel() + " - - " + key.attachment()));
                }
            }
        }
    }
}

