/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.wiki.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.debux.webmotion.wiki.service.WikiConfig;
import org.debux.webmotion.wiki.service.WikiGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiService {
    private static final Logger log = LoggerFactory.getLogger(WikiService.class);

    public String evalContent(String nameSpace, String pageName, String lang) throws Exception {
        File file = this.findPage(nameSpace, pageName, lang);
        if (file != null) {
            String content = this.generate(file);
            return content;
        }
        return null;
    }

    protected String generate(File page) throws Exception {
        String pageName = page.getName();
        int lastIndexOf = pageName.lastIndexOf(46) + 1;
        String type = pageName.substring(lastIndexOf);
        WikiGenerator generator = WikiGenerator.valueOf((String)type.toUpperCase());
        String generated = generator.generate(page);
        return generated;
    }

    public String generate(String type, String content) throws Exception {
        WikiGenerator generator = WikiGenerator.valueOf((String)type.toUpperCase());
        String generated = generator.generate(content);
        return generated;
    }

    public String getContent(String nameSpace, String pageName, String lang) throws Exception {
        File file = this.findPage(nameSpace, pageName, lang);
        if (file != null) {
            String content = IOUtils.toString((InputStream)new FileInputStream(file));
            return content;
        }
        return null;
    }

    public void save(String nameSpace, String pageName, String lang, String content) throws Exception {
        File file = this.findPage(nameSpace, pageName, lang);
        if (file != null) {
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(file));
        }
    }

    public File createPage(String nameSpace, String pageName, String lang, String type) throws Exception {
        File file = this.getPage(nameSpace, pageName, lang, type);
        if (!file.exists()) {
            file.getParentFile().mkdir();
            file.createNewFile();
        }
        return file;
    }

    public String getType(String nameSpace, String pageName, String lang) throws Exception {
        File file = this.findPage(nameSpace, pageName, lang);
        if (file != null) {
            String fileName = file.getName();
            String type = FilenameUtils.getExtension((String)fileName);
            return type;
        }
        return "";
    }

    protected File getPage(String nameSpace, String pageName, String lang, String type) throws Exception {
        String path = this.getPagePath();
        if (nameSpace != null) {
            path = path + File.separator + nameSpace;
        }
        String name = pageName;
        String[] language = WikiConfig.instance.getSupportedLanguage();
        if (language != null && language.length != 0 && lang != null) {
            name = name + "_" + lang;
        }
        name = name + "." + type;
        File page = new File(path, name);
        return page;
    }

    public File findPage(String nameSpace, String pageName, String lang) throws Exception {
        String path = this.getPagePath();
        if (nameSpace != null) {
            path = path + File.separator + nameSpace;
        }
        String prefix = pageName;
        String[] language = WikiConfig.instance.getSupportedLanguage();
        if (language != null && language.length != 0 && lang != null) {
            prefix = prefix + "_" + lang;
        }
        File directory = new File(path);
        log.debug("file search : " + directory.getAbsolutePath() + File.separator + prefix);
        Object[] files = directory.listFiles((FilenameFilter)new PrefixFileFilter(prefix + "."));
        log.debug("result search : " + Arrays.toString(files));
        if (files != null && files.length >= 1) {
            Object page = files[0];
            return page;
        }
        if (lang != null) {
            return this.findPage(nameSpace, pageName, null);
        }
        return null;
    }

    protected String getPagePath() throws URISyntaxException {
        String filePath = WikiConfig.instance.getFilePath();
        String path = filePath + File.separator;
        return path;
    }

    protected String getMediaPath() throws URISyntaxException {
        String filePath = WikiConfig.instance.getMediaPath();
        String path = filePath + File.separator;
        return path;
    }

    public void uploadMedia(String nameSpace, String mediaName, File file) throws Exception {
        File upload = this.getMedia(nameSpace, mediaName);
        upload.getParentFile().mkdir();
        upload.createNewFile();
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(upload));
    }

    public File getMedia(String nameSpace, String mediaName) throws Exception {
        String path = this.getMediaPath();
        if (nameSpace != null) {
            path = path + nameSpace + File.separator;
        }
        path = path + mediaName;
        File media = new File(path);
        return media;
    }

    public Map<String, List<String>> getSiteMap(String nameSpace) throws Exception {
        String pagePath = this.getPagePath();
        if (nameSpace != null) {
            pagePath = pagePath + nameSpace;
        }
        return this.getMap(pagePath, true);
    }

    public Map<String, List<String>> getMediaMap(String nameSpace) throws Exception {
        String mediaPath = this.getMediaPath();
        if (nameSpace != null) {
            mediaPath = mediaPath + nameSpace;
        }
        return this.getMap(mediaPath, false);
    }

    protected Map<String, List<String>> getMap(String path, boolean removeExtension) throws Exception {
        File[] files;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ArrayList<String> filesWithoutDirectory = new ArrayList<String>();
        result.put(null, filesWithoutDirectory);
        File pages = new File(path);
        for (File file : files = pages.listFiles()) {
            String fileName = file.getName();
            if (file.isFile()) {
                if (removeExtension) {
                    fileName = this.removeExtension(fileName);
                }
                filesWithoutDirectory.add(fileName);
                continue;
            }
            String[] list = file.list();
            ArrayList<String> filesWithDirectory = new ArrayList<String>(list.length);
            for (String pageName : list) {
                if (removeExtension) {
                    pageName = this.removeExtension(pageName);
                }
                filesWithDirectory.add(pageName);
            }
            result.put(fileName, filesWithDirectory);
        }
        return result;
    }

    protected String removeExtension(String name) {
        String value = name;
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf != -1) {
            value = name.substring(0, lastIndexOf);
        }
        return value;
    }
}

