/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.jpa;

import java.lang.reflect.Type;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.servlet.http.HttpServletRequest;
import org.debux.webmotion.jpa.GenericDAO;
import org.debux.webmotion.jpa.Jpa;
import org.debux.webmotion.jpa.Transactional;
import org.debux.webmotion.server.WebMotionServerListener;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.call.HttpContext;
import org.debux.webmotion.server.call.ServerContext;
import org.debux.webmotion.server.handler.ExecutorParametersInjectorHandler;
import org.debux.webmotion.server.mapping.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaListener
implements WebMotionServerListener {
    private static final Logger log = LoggerFactory.getLogger(JpaListener.class);

    public void onStart(Mapping mapping, ServerContext context) {
        context.addGlobalController(Jpa.class);
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new GenericDaoInjector());
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new EntityManagerInjector());
        context.addInjector((ExecutorParametersInjectorHandler.Injector)new EntityTransactionManager());
    }

    public void onStop(ServerContext context) {
    }

    public static class GenericDaoInjector
    implements ExecutorParametersInjectorHandler.Injector {
        public Object getValue(Mapping mapping, Call call, Class<?> type, Type generic) {
            if (GenericDAO.class.isAssignableFrom(type)) {
                HttpContext httpContext = call.getContext();
                HttpServletRequest request = httpContext.getRequest();
                return request.getAttribute(Transactional.CURRENT_GENERIC_DAO);
            }
            return null;
        }
    }

    public static class EntityManagerInjector
    implements ExecutorParametersInjectorHandler.Injector {
        public Object getValue(Mapping mapping, Call call, Class<?> type, Type generic) {
            if (EntityManager.class.isAssignableFrom(type)) {
                HttpContext httpContext = call.getContext();
                HttpServletRequest request = httpContext.getRequest();
                return request.getAttribute(Transactional.CURRENT_ENTITY_MANAGER);
            }
            return null;
        }
    }

    public static class EntityTransactionManager
    implements ExecutorParametersInjectorHandler.Injector {
        public Object getValue(Mapping mapping, Call call, Class<?> type, Type generic) {
            if (EntityTransaction.class.isAssignableFrom(type)) {
                HttpContext httpContext = call.getContext();
                HttpServletRequest request = httpContext.getRequest();
                return request.getAttribute(Transactional.CURRENT_ENTITY_TRANSACTION);
            }
            return null;
        }
    }
}

