/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.jpa;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.debux.webmotion.jpa.GenericDAO;
import org.debux.webmotion.jpa.IdentifiableEntity;
import org.debux.webmotion.jpa.Transactional;
import org.debux.webmotion.server.render.Render;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jpa
extends Transactional {
    private static final Logger log = LoggerFactory.getLogger(Jpa.class);

    public Render all(GenericDAO dao, HttpServletRequest request, String action, String id, String name, String callback) {
        if ("create".equals(action)) {
            return this.create(dao, request, callback);
        }
        if ("find".equals(action)) {
            return this.find(dao, request, callback, id);
        }
        if ("query".equals(action)) {
            return this.query(dao, request, callback, name);
        }
        if ("exec".equals(action)) {
            return this.exec(dao, request, callback, name);
        }
        if ("update".equals(action)) {
            return this.update(dao, request, callback, id);
        }
        if ("delete".equals(action)) {
            return this.delete(dao, request, callback, id);
        }
        return null;
    }

    public Render create(GenericDAO dao, HttpServletRequest request, String callback) {
        Map parameterMap = request.getParameterMap();
        GenericDAO.Parameters parameters = GenericDAO.Parameters.create(parameterMap);
        IdentifiableEntity entity = dao.create(parameters);
        return this.render(callback, "entity", entity);
    }

    public Render find(GenericDAO dao, HttpServletRequest request, String callback, String id) {
        IdentifiableEntity entity = dao.find(id);
        return this.render(callback, "entity", entity);
    }

    public Render query(GenericDAO dao, HttpServletRequest request, String callback, String name) {
        Map parameterMap = request.getParameterMap();
        GenericDAO.Parameters parameters = GenericDAO.Parameters.create(parameterMap);
        List query = dao.query(name, parameters);
        return this.render(callback, "queryResult", query);
    }

    public Render exec(GenericDAO dao, HttpServletRequest request, String callback, String name) {
        Map parameterMap = request.getParameterMap();
        GenericDAO.Parameters parameters = GenericDAO.Parameters.create(parameterMap);
        int query = dao.exec(name, parameters);
        return this.render(callback, "queryResult", query);
    }

    public Render update(GenericDAO dao, HttpServletRequest request, String callback, String id) {
        Map parameterMap = request.getParameterMap();
        GenericDAO.Parameters parameters = GenericDAO.Parameters.create(parameterMap);
        IdentifiableEntity entity = dao.update(id, parameters);
        return this.render(callback, "entity", entity);
    }

    public Render delete(GenericDAO dao, HttpServletRequest request, String callback, String id) {
        boolean deleted = dao.delete(id);
        return this.render(callback, "deleted", deleted);
    }

    protected Render render(String callback, String resultName, Object resultValue) {
        if (callback != null && !callback.isEmpty()) {
            return this.renderForward(callback, null, new Object[]{resultName, resultValue});
        }
        return this.renderJSON(new Object[]{resultValue});
    }
}

