/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.datavec.api.transform.serde.JsonMappers;
import org.datavec.api.writable.Writable;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.loader.NativeImageLoader;
import org.datavec.image.transform.ColorConversionTransform;
import org.datavec.image.transform.CropImageTransform;
import org.datavec.image.transform.EqualizeHistTransform;
import org.datavec.image.transform.FilterImageTransform;
import org.datavec.image.transform.FlipImageTransform;
import org.datavec.image.transform.ImageTransform;
import org.datavec.image.transform.RandomCropTransform;
import org.datavec.image.transform.ResizeImageTransform;
import org.datavec.image.transform.RotateImageTransform;
import org.datavec.image.transform.ScaleImageTransform;
import org.datavec.image.transform.WarpImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTransformProcess {
    private static final Logger log = LoggerFactory.getLogger(ImageTransformProcess.class);
    private List<ImageTransform> transformList;
    private int seed;

    public ImageTransformProcess(int seed, ImageTransform ... transforms) {
        this.seed = seed;
        this.transformList = Arrays.asList(transforms);
    }

    public ImageTransformProcess(int seed, List<ImageTransform> transformList) {
        this.seed = seed;
        this.transformList = transformList;
    }

    public ImageTransformProcess(Builder builder) {
        this(builder.seed, builder.transformList);
    }

    public List<Writable> execute(List<Writable> image) {
        throw new UnsupportedOperationException();
    }

    public INDArray executeArray(ImageWritable image) throws IOException {
        Random random = null;
        if (this.seed != 0) {
            random = new Random(this.seed);
        }
        ImageWritable currentImage = image;
        for (ImageTransform transform : this.transformList) {
            currentImage = transform.transform(currentImage, random);
        }
        NativeImageLoader imageLoader = new NativeImageLoader();
        return imageLoader.asMatrix(currentImage);
    }

    public ImageWritable execute(ImageWritable image) throws IOException {
        Random random = null;
        if (this.seed != 0) {
            random = new Random(this.seed);
        }
        ImageWritable currentImage = image;
        for (ImageTransform transform : this.transformList) {
            currentImage = transform.transform(currentImage, random);
        }
        return currentImage;
    }

    public ImageWritable transformFileUriToInput(URI uri) throws IOException {
        NativeImageLoader imageLoader = new NativeImageLoader();
        ImageWritable img = imageLoader.asWritable(new File(uri));
        return img;
    }

    public String toJson() {
        try {
            return JsonMappers.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return JsonMappers.getMapperYaml().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImageTransformProcess fromJson(String json) {
        try {
            return (ImageTransformProcess)JsonMappers.getMapper().readValue(json, ImageTransformProcess.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImageTransformProcess fromYaml(String yaml) {
        try {
            return (ImageTransformProcess)JsonMappers.getMapperYaml().readValue(yaml, ImageTransformProcess.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ImageTransform> getTransformList() {
        return this.transformList;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setTransformList(List<ImageTransform> transformList) {
        this.transformList = transformList;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageTransformProcess)) {
            return false;
        }
        ImageTransformProcess other = (ImageTransformProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        List<ImageTransform> this$transformList = this.getTransformList();
        List<ImageTransform> other$transformList = other.getTransformList();
        return !(this$transformList == null ? other$transformList != null : !((Object)this$transformList).equals(other$transformList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageTransformProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeed();
        List<ImageTransform> $transformList = this.getTransformList();
        result = result * 59 + ($transformList == null ? 43 : ((Object)$transformList).hashCode());
        return result;
    }

    public String toString() {
        return "ImageTransformProcess(transformList=" + this.getTransformList() + ", seed=" + this.getSeed() + ")";
    }

    public ImageTransformProcess() {
    }

    public static class Builder {
        private List<ImageTransform> transformList = new ArrayList<ImageTransform>();
        private int seed = 0;

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder cropImageTransform(int crop) {
            this.transformList.add(new CropImageTransform(crop));
            return this;
        }

        public Builder cropImageTransform(int cropTop, int cropLeft, int cropBottom, int cropRight) {
            this.transformList.add(new CropImageTransform(cropTop, cropLeft, cropBottom, cropRight));
            return this;
        }

        public Builder colorConversionTransform(int conversionCode) {
            this.transformList.add(new ColorConversionTransform(conversionCode));
            return this;
        }

        public Builder equalizeHistTransform(int conversionCode) {
            this.transformList.add(new EqualizeHistTransform(conversionCode));
            return this;
        }

        public Builder filterImageTransform(String filters, int width, int height) {
            this.transformList.add(new FilterImageTransform(filters, width, height));
            return this;
        }

        public Builder filterImageTransform(String filters, int width, int height, int channels) {
            this.transformList.add(new FilterImageTransform(filters, width, height, channels));
            return this;
        }

        public Builder flipImageTransform(int flipMode) {
            this.transformList.add(new FlipImageTransform(flipMode));
            return this;
        }

        public Builder randomCropTransform(int height, int width) {
            this.transformList.add(new RandomCropTransform(height, width));
            return this;
        }

        public Builder randomCropTransform(long seed, int height, int width) {
            this.transformList.add(new RandomCropTransform(seed, height, width));
            return this;
        }

        public Builder resizeImageTransform(int newWidth, int newHeight) {
            this.transformList.add(new ResizeImageTransform(newWidth, newHeight));
            return this;
        }

        public Builder rotateImageTransform(float angle) {
            this.transformList.add(new RotateImageTransform(angle));
            return this;
        }

        public Builder rotateImageTransform(float centerx, float centery, float angle, float scale) {
            this.transformList.add(new RotateImageTransform(centerx, centery, angle, scale));
            return this;
        }

        public Builder scaleImageTransform(float delta) {
            this.transformList.add(new ScaleImageTransform(delta));
            return this;
        }

        public Builder scaleImageTransform(float dx, float dy) {
            this.transformList.add(new ScaleImageTransform(dx, dy));
            return this;
        }

        public Builder warpImageTransform(float delta) {
            this.transformList.add(new WarpImageTransform(delta));
            return this;
        }

        public Builder warpImageTransform(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3, float dx4, float dy4) {
            this.transformList.add(new WarpImageTransform(dx1, dy1, dx2, dy2, dx3, dy3, dx4, dy4));
            return this;
        }

        public ImageTransformProcess build() {
            return new ImageTransformProcess(this);
        }
    }
}

