/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractDataNucleusMojo
extends AbstractMojo {
    protected File metadataDirectory;
    protected String metadataIncludes;
    protected String metadataExcludes;
    private List classpathElements;
    protected List pluginArtifacts;
    protected String log4jConfiguration;
    protected String jdkLogConfiguration;
    protected boolean verbose;
    protected String persistenceUnitName;
    protected String api;

    public void execute() throws MojoExecutionException {
        if (!this.metadataDirectory.exists()) {
            this.getLog().warn((CharSequence)("No files to run DataNucleus tool '" + this.getToolName() + "'" + " since specified metadata directory '" + this.metadataDirectory.getAbsolutePath() + "'" + " is not available."));
            return;
        }
        List files = this.findMetadataFiles();
        if (files.size() == 0) {
            this.getLog().warn((CharSequence)("No files to run DataNucleus tool '" + this.getToolName() + "'"));
            return;
        }
        this.getLog().debug((CharSequence)("Metadata Directory is : " + this.metadataDirectory.getAbsolutePath()));
        try {
            this.executeDataNucleusTool(this.pluginArtifacts, files);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing the DataNucleus tool '" + this.getToolName() + "'.", (Exception)((Object)e));
        }
    }

    protected URL getLog4JConfiguration() {
        if (this.log4jConfiguration != null) {
            URL log4jURL = ((Object)((Object)this)).getClass().getResource(this.log4jConfiguration);
            if (log4jURL == null && this.log4jConfiguration != null) {
                try {
                    log4jURL = new URL("file:" + this.log4jConfiguration);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return log4jURL;
        }
        return null;
    }

    protected URL getJdkLogConfiguration() {
        if (this.jdkLogConfiguration != null) {
            URL jdkLogURL = ((Object)((Object)this)).getClass().getResource(this.jdkLogConfiguration);
            if (jdkLogURL == null && this.jdkLogConfiguration != null) {
                try {
                    jdkLogURL = new URL("file:" + this.jdkLogConfiguration);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return jdkLogURL;
        }
        return null;
    }

    protected List findMetadataFiles() throws MojoExecutionException {
        List files;
        try {
            files = FileUtils.getFiles((File)this.metadataDirectory, (String)this.metadataIncludes, (String)this.metadataExcludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for metadata files in '" + this.metadataDirectory.getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    protected List getUniqueClasspathElements() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.metadataDirectory.getAbsolutePath());
        Iterator it = this.classpathElements.iterator();
        while (it.hasNext()) {
            String pathelem = (String)it.next();
            if (ret.contains(new File(pathelem).getAbsolutePath())) continue;
            ret.add(pathelem);
        }
        return ret;
    }

    protected abstract void executeDataNucleusTool(List var1, List var2) throws CommandLineException, MojoExecutionException;

    protected abstract String getToolName();

    protected void executeCommandLine(Commandline cl) throws CommandLineException, MojoExecutionException {
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        this.getLog().debug((CharSequence)("Exit code: " + exitCode));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)(" Standard output from the DataNucleus tool " + this.getToolName() + " :"));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().info((CharSequence)stdout.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)(" Standard error from the DataNucleus tool + " + this.getToolName() + " :"));
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)stderr.getOutput());
            this.getLog().error((CharSequence)"--------------------");
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("The DataNucleus tool " + this.getToolName() + " exited with a non-null exit code.");
        }
    }
}

