/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.functions.NameSupplier;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.proxy.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoProxyResourceCollection
extends AbstractPlexusIoResourceCollectionWithAttributes {
    private PlexusIoResourceCollection src;

    public PlexusIoProxyResourceCollection(@Nonnull PlexusIoResourceCollection src) {
        this.src = src;
    }

    public PlexusIoResourceCollection getSrc() {
        return this.src;
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setDefaultFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setDefaultDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setOverrideFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setOverrideDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    @Override
    public void setStreamTransformer(InputStreamTransformer streamTransformer) {
        if (this.src instanceof AbstractPlexusIoResourceCollection) {
            ((AbstractPlexusIoResourceCollection)this.src).setStreamTransformer(streamTransformer);
        }
        super.setStreamTransformer(streamTransformer);
    }

    protected FileSelector getDefaultFileSelector() {
        IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
        fileSelector.setIncludes(this.getIncludes());
        fileSelector.setExcludes(this.getExcludes());
        fileSelector.setCaseSensitive(this.isCaseSensitive());
        fileSelector.setUseDefaultExcludes(this.isUsingDefaultExcludes());
        return fileSelector;
    }

    private String getNonEmptyPrfix() {
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        return new ForwardingIterator(this.getSrc().getResources());
    }

    @Override
    public String getName(PlexusIoResource resource) {
        String name = resource.getName();
        FileMapper[] mappers = this.getFileMappers();
        if (mappers != null) {
            for (FileMapper mapper : mappers) {
                name = mapper.getMappedFileName(name);
            }
        }
        return name;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.src.getLastModified();
    }

    abstract class DualSupplier
    implements NameSupplier,
    ResourceAttributeSupplier {
        DualSupplier() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ForwardingIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        Iterator<PlexusIoResource> iter;
        private final FileSelector fileSelector;
        private PlexusIoResource next;
        private final String prefix;

        ForwardingIterator(Iterator<PlexusIoResource> resources) {
            this.fileSelector = PlexusIoProxyResourceCollection.this.getDefaultFileSelector();
            this.next = null;
            this.prefix = PlexusIoProxyResourceCollection.this.getNonEmptyPrfix();
            this.iter = resources;
        }

        @Override
        public boolean hasNext() {
            this.next = this.getNextResource();
            return this.next != null;
        }

        @Override
        public PlexusIoResource next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.iter instanceof Closeable) {
                ((Closeable)((Object)this.iter)).close();
            }
        }

        PlexusIoResource getNextResource() {
            if (!this.iter.hasNext()) {
                return null;
            }
            PlexusIoResource plexusIoResource = this.iter.next();
            try {
                if (!this.fileSelector.isSelected(plexusIoResource) || !PlexusIoProxyResourceCollection.this.isSelected(plexusIoResource)) {
                    return this.getNextResource();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (plexusIoResource.isDirectory() && !PlexusIoProxyResourceCollection.this.isIncludingEmptyDirectories()) {
                return this.getNextResource();
            }
            PlexusIoResourceAttributes attrs = null;
            if (plexusIoResource instanceof ResourceAttributeSupplier) {
                attrs = ((ResourceAttributeSupplier)((Object)plexusIoResource)).getAttributes();
            }
            if (attrs == null) {
                attrs = SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
            }
            attrs = PlexusIoProxyResourceCollection.this.mergeAttributes(attrs, plexusIoResource.isDirectory());
            if (this.prefix != null) {
                final String name = plexusIoResource.getName();
                final PlexusIoResourceAttributes attrs2 = attrs;
                DualSupplier supplier = new DualSupplier(){

                    public String getName() {
                        return ForwardingIterator.this.prefix + name;
                    }

                    public PlexusIoResourceAttributes getAttributes() {
                        return attrs2;
                    }
                };
                plexusIoResource = ProxyFactory.createProxy(plexusIoResource, supplier);
            }
            return plexusIoResource;
        }
    }
}

