/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.plexus.util.WriterFactory;

public class VersionXmlGenerator {
    public void generate(File outputDir, Collection jarResources) throws MojoExecutionException {
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir must not be null");
        }
        BufferedWriter writer = null;
        try {
            File versionXmlFile = new File(outputDir, "version.xml");
            writer = new BufferedWriter((Writer)WriterFactory.newXmlWriter((File)versionXmlFile));
            this.generateXml(writer, jarResources);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create the version.xml file", (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void generateXml(BufferedWriter writer, Collection jarResources) throws IOException {
        writer.write("<?xml version=\"1.0\"?>");
        writer.newLine();
        writer.write("<jnlp-versions>");
        writer.newLine();
        Iterator itr = jarResources.iterator();
        while (itr.hasNext()) {
            JarResource jarResource = (JarResource)itr.next();
            writer.write("  <resource>");
            writer.newLine();
            writer.write("    <pattern>");
            writer.newLine();
            writer.write("      <name>");
            writer.write(jarResource.getHrefValue());
            writer.write("</name>");
            writer.newLine();
            writer.write("      <version-id>");
            writer.write(jarResource.getVersion());
            writer.write("</version-id>");
            writer.newLine();
            writer.write("    </pattern>");
            writer.newLine();
            writer.write("    <file>");
            writer.write(jarResource.getArtifact().getFile().getName());
            writer.write("</file>");
            writer.newLine();
            writer.write("  </resource>");
            writer.newLine();
        }
        writer.write("</jnlp-versions>");
        writer.newLine();
    }
}

