/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.JnlpConfig;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.dependency.filenaming.DependencyFilenameStrategy;
import org.codehaus.mojo.webstart.generator.AbstractGeneratorExtraConfigWithDeps;

public class GeneratorConfig
extends AbstractGeneratorExtraConfigWithDeps {
    private final Collection<Artifact> packagedJnlpArtifacts;
    private final List<JnlpExtension> jnlpExtensions;
    private final String codebase;
    private final JnlpConfig jnlp;

    public GeneratorConfig(String libPath, boolean pack200, boolean outputJarVersions, boolean useUniqueVersions, Artifact artifactWithMainClass, DependencyFilenameStrategy dependencyFilenameStrategy, Collection<Artifact> packagedJnlpArtifacts, List<JnlpExtension> jnlpExtensions, String codebase, JnlpConfig jnlp) {
        super(libPath, pack200, outputJarVersions, useUniqueVersions, artifactWithMainClass, dependencyFilenameStrategy);
        this.packagedJnlpArtifacts = packagedJnlpArtifacts;
        this.jnlpExtensions = jnlpExtensions;
        this.codebase = codebase;
        this.jnlp = jnlp;
    }

    public Collection<Artifact> getPackagedJnlpArtifacts() {
        return this.packagedJnlpArtifacts;
    }

    public List<JnlpExtension> getJnlpExtensions() {
        return this.jnlpExtensions;
    }

    public boolean hasJnlpExtensions() {
        return CollectionUtils.isNotEmpty(this.jnlpExtensions);
    }

    @Override
    public String getJnlpSpec() {
        if (this.jnlp.getSpec() != null) {
            return this.jnlp.getSpec();
        }
        return "1.0+";
    }

    @Override
    public String getOfflineAllowed() {
        if (this.jnlp.getOfflineAllowed() != null) {
            return this.jnlp.getOfflineAllowed();
        }
        return "false";
    }

    @Override
    public String getAllPermissions() {
        if (this.jnlp.getAllPermissions() != null) {
            return this.jnlp.getAllPermissions();
        }
        return "true";
    }

    @Override
    public String getJ2seVersion() {
        if (this.jnlp.getJ2seVersion() != null) {
            return this.jnlp.getJ2seVersion();
        }
        return "1.5+";
    }

    @Override
    public String getJnlpCodeBase() {
        return this.codebase;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.jnlp.getProperties();
    }
}

