/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.mojo.webstart.util.JarUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=JarUtil.class, hint="default")
public class DefaultJarUtil
implements JarUtil {
    @Requirement
    protected IOUtil ioUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateManifestEntries(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        Manifest manifest = this.createManifest(jar, manifestentries);
        File updatedUnprocessedJarFile = new File(jar.getParent(), jar.getName() + "_updateManifestEntriesJar");
        ZipFile originalJar = null;
        JarOutputStream targetJar = null;
        try {
            originalJar = new ZipFile(jar);
            targetJar = new JarOutputStream((OutputStream)new FileOutputStream(updatedUnprocessedJarFile), manifest);
            Enumeration<? extends ZipEntry> entries = originalJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                targetJar.putNextEntry(newEntry);
                if (!entry.isDirectory()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = originalJar.getInputStream(entry);
                        org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)targetJar);
                        inputStream.close();
                    }
                    finally {
                        org.apache.maven.shared.utils.io.IOUtil.close((InputStream)inputStream);
                    }
                }
                targetJar.closeEntry();
            }
            targetJar.close();
            originalJar.close();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while updating manifest of " + jar.getName(), (Exception)e);
            }
            catch (Throwable throwable) {
                org.apache.maven.shared.utils.io.IOUtil.close(targetJar);
                this.ioUtil.close(originalJar);
                throw throwable;
            }
        }
        org.apache.maven.shared.utils.io.IOUtil.close((OutputStream)targetJar);
        this.ioUtil.close(originalJar);
        this.ioUtil.deleteFile(jar);
        this.ioUtil.renameTo(updatedUnprocessedJarFile, jar);
    }

    protected Manifest createManifest(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null || manifest.getMainAttributes().isEmpty()) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            Set<Map.Entry<String, String>> entrySet = manifestentries.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                manifest.getMainAttributes().putValue(entry.getKey(), entry.getValue());
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading manifest from " + jar.getAbsolutePath(), (Exception)e);
        }
        finally {
            this.ioUtil.close(jarFile);
        }
    }
}

