/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.InversionArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.AbstractBaseJnlpMojo;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.JnlpFile;
import org.codehaus.mojo.webstart.ResolvedJarResource;
import org.codehaus.mojo.webstart.ResolvedJnlpFile;
import org.codehaus.mojo.webstart.generator.JarResourcesGenerator;
import org.codehaus.mojo.webstart.generator.SimpleGeneratorExtraConfig;
import org.codehaus.mojo.webstart.generator.VersionXmlGenerator;
import org.codehaus.mojo.webstart.util.ArtifactUtil;
import org.codehaus.mojo.webstart.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="jnlp-download-servlet", requiresProject=true, inheritByDefault=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JnlpDownloadServletMojo
extends AbstractBaseJnlpMojo {
    @Parameter(defaultValue="webstart")
    private String outputDirectoryName;
    @Parameter(required=true)
    private List<JnlpFile> jnlpFiles;
    @Parameter
    private List<JarResource> commonJarResources;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        IOUtil ioUtil = this.getIoUtil();
        ioUtil.makeDirectoryIfNecessary(this.getWorkDirectory());
        ioUtil.copyResources(this.getResourcesDirectory(), this.getWorkDirectory());
        this.getLog().info((CharSequence)"-- Prepare commons jar resources");
        Set<Object> resolvedCommonJarResources = CollectionUtils.isEmpty(this.commonJarResources) ? Collections.emptySet() : this.resolveJarResources(this.commonJarResources, null);
        HashSet<ResolvedJarResource> allResolvedJarResources = new HashSet<ResolvedJarResource>();
        allResolvedJarResources.addAll(resolvedCommonJarResources);
        this.getLog().info((CharSequence)"-- Prepare jnlp files");
        HashSet<ResolvedJnlpFile> resolvedJnlpFiles = new HashSet<ResolvedJnlpFile>();
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            this.verboseLog("prepare jnlp " + jnlpFile);
            Set<ResolvedJarResource> resolvedJarResources = this.resolveJarResources(jnlpFile.getJarResources(), resolvedCommonJarResources);
            allResolvedJarResources.addAll(resolvedJarResources);
            ResolvedJnlpFile resolvedJnlpFile = new ResolvedJnlpFile(jnlpFile, resolvedJarResources);
            resolvedJnlpFiles.add(resolvedJnlpFile);
        }
        this.signOrRenameJars();
        for (ResolvedJnlpFile resolvedJnlpFile : resolvedJnlpFiles) {
            this.generateJnlpFile(resolvedJnlpFile, this.getLibPath());
        }
        this.generateVersionXml(allResolvedJarResources);
        File outputDir = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + File.separator + this.outputDirectoryName);
        ioUtil.makeDirectoryIfNecessary(outputDir);
        ioUtil.copyDirectoryStructure(this.getWorkDirectory(), outputDir);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    private void checkConfiguration() throws MojoExecutionException {
        this.checkPack200();
        if (CollectionUtils.isEmpty(this.jnlpFiles)) {
            throw new MojoExecutionException("Configuration error: At least one <jnlpFile> element must be specified");
        }
        if (this.jnlpFiles.size() == 1 && StringUtils.isEmpty((String)this.jnlpFiles.get(0).getOutputFilename())) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified in single set of jnlpFiles. Using default output file name: launch.jnlp.");
            this.jnlpFiles.get(0).setOutputFilename("launch.jnlp");
        }
        HashSet<String> filenames = new HashSet<String>(this.jnlpFiles.size());
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            if (!filenames.add(jnlpFile.getOutputFilename())) {
                throw new MojoExecutionException("Configuration error: Unique JNLP filenames must be provided. The following file name appears more than once [" + jnlpFile.getOutputFilename() + "].");
            }
            this.checkJnlpFileuration(jnlpFile);
        }
        if (CollectionUtils.isNotEmpty(this.commonJarResources)) {
            for (JarResource jarResource : this.commonJarResources) {
                this.checkMandatoryJarResourceFields(jarResource);
                if (jarResource.getMainClass() == null) continue;
                throw new MojoExecutionException("Configuration Error: A mainClass must not be specified on a JarResource in the commonJarResources collection.");
            }
            for (JnlpFile jnlpFile : this.jnlpFiles) {
                for (JarResource jarResource : jnlpFile.getJarResources()) {
                    if (!this.commonJarResources.contains(jarResource)) continue;
                    String message = "Configuration Error: The jar resource element for artifact " + jarResource + " defined in common jar resources is duplicated in the jar " + "resources configuration of the jnlp file identified by the template file " + jnlpFile.getTemplateFilename() + ".";
                    throw new MojoExecutionException(message);
                }
            }
        }
    }

    private void checkJnlpFileuration(JnlpFile jnlpFile) throws MojoExecutionException {
        if (StringUtils.isBlank((String)jnlpFile.getOutputFilename())) {
            throw new MojoExecutionException("Configuration error: An outputFilename must be specified for each jnlpFile element");
        }
        if (StringUtils.isBlank((String)jnlpFile.getTemplateFilename())) {
            this.verboseLog("No templateFilename found for " + jnlpFile.getOutputFilename() + ". Will use the default template.");
        } else {
            File templateFile = new File(this.getTemplateDirectory(), jnlpFile.getTemplateFilename());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP template does not exist: [" + templateFile + "]");
            }
        }
        List<JarResource> jnlpJarResources = jnlpFile.getJarResources();
        if (CollectionUtils.isEmpty(jnlpJarResources)) {
            throw new MojoExecutionException("Configuration error: A non-empty <jarResources> element must be specified in the plugin configuration for the JNLP file named [" + jnlpFile.getOutputFilename() + "]");
        }
        JarResource mainJarResource = null;
        for (JarResource jarResource : jnlpJarResources) {
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() == null) continue;
            if (mainJarResource != null) {
                throw new MojoExecutionException("Configuration error: More than one <jarResource> element has been declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
            }
            jnlpFile.setMainClass(jarResource.getMainClass());
            mainJarResource = jarResource;
        }
        if (mainJarResource == null) {
            throw new MojoExecutionException("Configuration error: Exactly one <jarResource> element must be declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
    }

    private void checkMandatoryJarResourceFields(JarResource jarResource) throws MojoExecutionException {
        if (!jarResource.isMandatoryField()) {
            throw new MojoExecutionException("Configuration error: groupId, artifactId or version missing for jarResource[" + jarResource + "].");
        }
    }

    private Set<ResolvedJarResource> resolveJarResources(Collection<JarResource> configuredJarResources, Set<ResolvedJarResource> commonJarResources) throws MojoExecutionException {
        Artifact artifact;
        HashSet<ResolvedJarResource> collectedJarResources = new HashSet<ResolvedJarResource>();
        if (commonJarResources != null) {
            collectedJarResources.addAll(commonJarResources);
        }
        ArtifactUtil artifactUtil = this.getArtifactUtil();
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet<MavenProject> siblingProjects = new HashSet<MavenProject>();
        for (JarResource jarResource : configuredJarResources) {
            artifact = artifactUtil.createArtifact(jarResource);
            MavenProject siblingProject = artifactUtil.resolveFromReactor(artifact, this.getProject(), this.reactorProjects);
            if (siblingProject == null) {
                artifactUtil.resolveFromRepositories(artifact, this.getRemoteRepositories(), this.getLocalRepository());
                artifacts.add(artifact);
            } else {
                artifact = siblingProject.getArtifact();
                siblingProjects.add(siblingProject);
            }
            if (StringUtils.isNotBlank((String)jarResource.getMainClass())) {
                if (artifact == null) {
                    throw new IllegalStateException("Implementation Error: The given jarResource cannot be checked for a main class until the underlying artifact has been resolved: [" + jarResource + "]");
                }
                boolean containsMainClass = artifactUtil.artifactContainsMainClass(artifact, jarResource);
                if (!containsMainClass) {
                    throw new MojoExecutionException("The jar specified by the following jarResource does not contain the declared main class:" + jarResource);
                }
            }
            ResolvedJarResource resolvedJarResource = new ResolvedJarResource(jarResource, artifact);
            this.getLog().debug((CharSequence)("Add jarResource (configured): " + jarResource));
            collectedJarResources.add(resolvedJarResource);
        }
        if (!this.isExcludeTransitive()) {
            AndArtifactFilter artifactFilter = new AndArtifactFilter();
            artifactFilter.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
            artifactFilter.add((ArtifactFilter)new InversionArtifactFilter((ArtifactFilter)new TypeArtifactFilter("pom")));
            Set<Artifact> set = this.getArtifactUtil().resolveTransitively(artifacts, siblingProjects, this.getProject().getArtifact(), this.getLocalRepository(), this.getRemoteRepositories(), (ArtifactFilter)artifactFilter);
            for (Artifact resolvedArtifact : set) {
                ResolvedJarResource newJarResource = new ResolvedJarResource(resolvedArtifact);
                if (collectedJarResources.contains(newJarResource)) continue;
                this.getLog().debug((CharSequence)("Add jarResource (transitive): " + newJarResource));
                collectedJarResources.add(newJarResource);
            }
        }
        for (ResolvedJarResource resolvedJarResource : collectedJarResources) {
            artifact = resolvedJarResource.getArtifact();
            boolean copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(artifact.getFile(), this.getLibDirectory());
            if (copied) {
                String name = artifact.getFile().getName();
                this.verboseLog("Adding " + name + " to modifiedJnlpArtifacts list.");
                this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
            }
            if (!resolvedJarResource.isOutputJarVersion()) continue;
            String hrefValue = this.buildHrefValue(artifact);
            resolvedJarResource.setHrefValue(hrefValue);
        }
        return collectedJarResources;
    }

    private void generateJnlpFile(ResolvedJnlpFile jnlpFile, String libPath) throws MojoExecutionException {
        File jnlpOutputFile = new File(this.getWorkDirectory(), jnlpFile.getOutputFilename());
        Set<ResolvedJarResource> jarResources = jnlpFile.getJarResources();
        JarResourcesGenerator jnlpGenerator = new JarResourcesGenerator(this.getLog(), this.getProject(), this.getTemplateDirectory(), "default-jnlp-servlet-template.vm", jnlpOutputFile, jnlpFile.getTemplateFilename(), jarResources, jnlpFile.getMainClass(), this.getWebstartJarURLForVelocity(), libPath, this.getEncoding());
        jnlpGenerator.setExtraConfig(new SimpleGeneratorExtraConfig(jnlpFile.getProperties(), this.getCodebase()));
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("The following error occurred attempting to generate the JNLP deployment descriptor: " + e, e);
        }
    }

    private void generateVersionXml(Set<ResolvedJarResource> jarResources) throws MojoExecutionException {
        VersionXmlGenerator generator = new VersionXmlGenerator(this.getEncoding());
        generator.generate(this.getLibDirectory(), jarResources);
    }

    private String buildHrefValue(Artifact artifact) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(artifact.getArtifactId());
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            sbuf.append("-").append(artifact.getClassifier());
        }
        sbuf.append(".").append(artifact.getArtifactHandler().getExtension());
        return sbuf.toString();
    }
}

