/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="update-child-modules", aggregator=true, threadSafe=true)
public class UpdateChildModulesMojo
extends AbstractVersionsUpdaterMojo {
    private transient String sourceGroupId = null;
    private transient String sourceArtifactId = null;
    private transient String sourceVersion = null;

    @Inject
    public UpdateChildModulesMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean didSomething = false;
        try {
            Map reactor = PomHelper.getChildModels((MavenProject)this.getProject(), (Log)this.getLog());
            ArrayList order = new ArrayList(reactor.keySet());
            order.sort((o1, o2) -> {
                int d2;
                Model m1 = (Model)reactor.get(o1);
                Model m2 = (Model)reactor.get(o2);
                int d1 = PomHelper.getReactorParentCount((Map)reactor, (Model)m1);
                if (d1 < (d2 = PomHelper.getReactorParentCount((Map)reactor, (Model)m2))) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            });
            for (File sourcePath : order) {
                Model sourceModel = (Model)reactor.get(sourcePath);
                this.getLog().debug((CharSequence)(sourcePath.length() == 0L ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent."));
                UpdateChildModulesMojo updateChildModulesMojo = this;
                synchronized (updateChildModulesMojo) {
                    this.sourceGroupId = PomHelper.getGroupId((Model)sourceModel);
                    if (this.sourceGroupId == null) {
                        this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a groupId."));
                        continue;
                    }
                    this.sourceArtifactId = PomHelper.getArtifactId((Model)sourceModel);
                    if (this.sourceArtifactId == null) {
                        this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing an artifactId."));
                        continue;
                    }
                    this.sourceVersion = PomHelper.getVersion((Model)sourceModel);
                    if (this.sourceVersion == null) {
                        this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a version."));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Looking for modules which use " + ArtifactUtils.versionlessKey((String)this.sourceGroupId, (String)this.sourceArtifactId) + " as their parent to update it to " + this.sourceVersion));
                    for (Map.Entry target : PomHelper.getChildModels((Map)reactor, (String)this.sourceGroupId, (String)this.sourceArtifactId).entrySet()) {
                        File moduleProjectFile = (File)target.getKey();
                        String moduleName = moduleProjectFile.getParent();
                        Model targetModel = (Model)target.getValue();
                        Parent parent = targetModel.getParent();
                        if (this.sourceVersion.equals(parent.getVersion())) {
                            this.getLog().debug((CharSequence)("Module: " + moduleName + " parent is " + ArtifactUtils.versionlessKey((String)this.sourceGroupId, (String)this.sourceArtifactId) + ":" + this.sourceVersion));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Module: " + moduleName));
                        this.getLog().info((CharSequence)("    parent was " + ArtifactUtils.versionlessKey((String)this.sourceGroupId, (String)this.sourceArtifactId) + ":" + parent.getVersion()));
                        this.getLog().info((CharSequence)("    updated to " + ArtifactUtils.versionlessKey((String)this.sourceGroupId, (String)this.sourceArtifactId) + ":" + this.sourceVersion));
                        this.process(moduleProjectFile);
                        didSomething = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (!didSomething) {
            this.getLog().info((CharSequence)"All child modules are up to date.");
        }
    }

    @Override
    protected synchronized void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        this.getLog().debug((CharSequence)("Updating parent to " + this.sourceVersion));
        if (PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)this.sourceVersion)) {
            this.getLog().debug((CharSequence)("Made an update to " + this.sourceVersion));
        }
    }
}

