/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UnlockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("-(\\d{8}\\.\\d{6})-(\\d+)$");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            this.unlockSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
        }
        if (this.isProcessingDependencies()) {
            this.unlockSnapshots(pom, this.getProject().getDependencies());
        }
    }

    private void unlockSnapshots(ModifiedPomXMLEventReader pom, List dependencies) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = this.matchSnapshotRegex.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length()) continue;
            String unlockedVersion = versionMatcher.replaceFirst("-SNAPSHOT");
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), unlockedVersion)) continue;
            this.getLog().info((CharSequence)("Unlocked " + this.toString(dep) + " to version " + unlockedVersion));
        }
    }
}

