/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.codehaus.mojo.sonar.MavenPluginManagerHelper;
import org.codehaus.mojo.sonar.ServerMetadata;
import org.codehaus.mojo.sonar.bootstrap.InternalMojoBootstraper;
import org.codehaus.mojo.sonar.bootstrap.RunnerBootstraper;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class SonarMojo
extends AbstractMojo {
    protected MavenProject project;
    private MavenSession session;
    private String sonarHostURL;
    private boolean skip;
    protected MavenPluginManager mavenPluginManager;
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    private LifecycleExecutor lifecycleExecutor;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    private SecDispatcher securityDispatcher;
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"sonar.skip = true: Skipping analysis");
            return;
        }
        try {
            ServerMetadata server = new ServerMetadata(this.sonarHostURL);
            server.logSettings(this.getLog());
            String mavenVersion = this.runtimeInformation.getMavenVersion();
            this.checkVersionRequirements(server, mavenVersion);
            if (server.supportsSonarQubeRunnerBootstrappingFromMaven()) {
                new RunnerBootstraper(this.runtimeInformation, this.getLog(), this.session, this.lifecycleExecutor, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder, this.securityDispatcher).execute();
            } else {
                new InternalMojoBootstraper(server, this.mavenPluginManager, this.mavenPluginManagerHelper).start(this.project, this.session);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute SonarQube analysis", (Exception)e);
        }
    }

    @VisibleForTesting
    void checkVersionRequirements(ServerMetadata server, String mavenVersion) throws IOException, MojoExecutionException {
        if (!server.supportsMaven3()) {
            throw new MojoExecutionException("SonarQube " + server.getVersion() + " does not support Maven 3");
        }
        DefaultArtifactVersion artifactMavenVersion = new DefaultArtifactVersion(mavenVersion);
        if ((artifactMavenVersion.getMajorVersion() > 3 || artifactMavenVersion.getMajorVersion() == 3 && artifactMavenVersion.getMinorVersion() >= 1) && !server.supportsMaven3_1()) {
            throw new MojoExecutionException("SonarQube " + server.getVersion() + " does not support Maven 3.1+. Please upgrade to SonarQube 3.7 or greater.");
        }
    }

    @VisibleForTesting
    void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @VisibleForTesting
    void setSonarHostURL(String sonarHostURL) {
        this.sonarHostURL = sonarHostURL;
    }
}

