/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.Collection;
import java.util.Locale;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.mojo.license.api.ThirdPartyDetails;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractLicenseReportRenderer
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;

    public AbstractLicenseReportRenderer(Sink sink, String bundleName, I18N i18n, Locale locale) {
        super(sink);
        this.bundleName = bundleName;
        this.i18n = i18n;
        this.locale = locale;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    protected void renderErrorIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    protected void renderSuccessIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_success_sml.gif");
        this.sink.figure_();
    }

    protected void renderInfoIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    protected String getGAV(ThirdPartyDetails details) {
        return ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId()) + ":" + details.getVersion();
    }

    protected void sinkHeaderCellText(String width, String text) {
        SinkEventAttributeSet attrs = new SinkEventAttributeSet();
        attrs.addAttribute((Object)"width", (Object)width);
        this.sink.tableHeaderCell((SinkEventAttributes)attrs);
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkCellText(String width, String text) {
        SinkEventAttributeSet attrs = new SinkEventAttributeSet();
        attrs.addAttribute((Object)"width", (Object)width);
        this.sink.tableCell((SinkEventAttributes)attrs);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void renderThirdPartySummaryTableRow(ThirdPartyDetails details) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (details.hasPomLicenses()) {
            this.renderSuccessIcon();
        } else if (details.hasThirdPartyLicenses()) {
            this.renderWarningIcon();
        } else {
            this.renderErrorIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        String gav = this.getGAV(details);
        this.sink.link("#" + gav);
        this.sink.text(gav);
        this.sink.link_();
        this.sink.tableCell_();
        this.tableCell(details.getScope());
        this.tableCell(details.getClassifier());
        this.tableCell(details.getType());
        this.sink.tableCell();
        if (details.hasLicenses()) {
            String[] licenses = details.getLicenses();
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
        } else {
            this.sink.text("-");
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderThirdPartyDetailTable(ThirdPartyDetails details) {
        String cellWidth = "80%";
        String headerWidth = "20%";
        this.startTable(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.status"));
        SinkEventAttributeSet attrs = new SinkEventAttributeSet();
        attrs.addAttribute((Object)"width", (Object)"80%");
        this.sink.tableCell((SinkEventAttributes)attrs);
        if (details.hasPomLicenses()) {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.licenseFromPom"));
        } else if (details.hasThirdPartyLicenses()) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.licenseFromThirdParty"));
        } else {
            this.renderErrorIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.status.noLicense"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.gav"));
        this.sinkCellText("80%", this.getGAV(details));
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.scope"));
        this.sinkCellText("80%", details.getScope());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.classifier"));
        this.sinkCellText("80%", details.getClassifier());
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sinkHeaderCellText("20%", this.getText("report.type"));
        this.sinkCellText("80%", details.getType());
        this.sink.tableRow_();
        String[] licenses = details.getLicenses();
        if (details.hasPomLicenses()) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sink.tableCell((SinkEventAttributes)attrs);
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        } else if (details.hasThirdPartyLicenses()) {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sink.tableCell((SinkEventAttributes)attrs);
            for (int i = 0; i < licenses.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                this.sink.text(licenses[i]);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        } else {
            this.sink.tableRow();
            this.sinkHeaderCellText("20%", this.getText("report.licenses"));
            this.sinkCellText("80%", this.getText("report.no.license"));
            this.sink.tableRow_();
        }
        this.endTable();
    }

    protected void renderThirdPartySummaryTable(Collection<ThirdPartyDetails> collection) {
        this.startTable();
        this.tableHeader(new String[]{this.getText("report.status"), this.getText("report.gav"), this.getText("report.scope"), this.getText("report.classifier"), this.getText("report.type"), this.getText("report.licenses")});
        for (ThirdPartyDetails details : collection) {
            this.renderThirdPartySummaryTableRow(details);
        }
        this.endTable();
    }
}

