/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLicenseMojo.class);
    @Parameter(property="license.verbose", defaultValue="${maven.verbose}")
    boolean verbose;
    @Parameter(property="license.encoding", defaultValue="${project.build.sourceEncoding}")
    String encoding;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    protected final MavenProjectHelper projectHelper;

    protected AbstractLicenseMojo(MavenProjectHelper projectHelper) {
        this.projectHelper = Objects.requireNonNull(projectHelper, "projectHelper cannot be null");
    }

    public abstract boolean isSkip();

    protected abstract void init() throws Exception;

    protected abstract void doAction() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean mustSkip;
            if (this.getLog().isDebugEnabled()) {
                this.setVerbose(true);
            }
            if (mustSkip = this.isSkip()) {
                LOG.info("skip flag is on, will skip goal.");
                return;
            }
            boolean canContinue = this.checkPackaging();
            if (!canContinue) {
                LOG.info("The goal is skip due to packaging '{}'", (Object)this.getProject().getPackaging());
                return;
            }
            try {
                this.checkEncoding();
                this.init();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not init goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
            if (this.shouldSkip()) {
                LOG.info("All files are up to date, skip goal execution.");
                return;
            }
            try {
                this.doAction();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not execute goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
        }
        finally {
            this.afterExecute();
        }
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final MavenProject getProject() {
        return this.project;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void afterExecute() {
    }

    protected boolean checkPackaging() {
        return true;
    }

    protected boolean shouldSkip() {
        return false;
    }

    protected boolean acceptPackaging(String ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (String p : packages) {
            if (!p.equals(projectPackaging)) continue;
            return true;
        }
        return false;
    }

    protected boolean rejectPackaging(String ... packages) {
        String projectPackaging = this.getProject().getPackaging();
        for (String p : packages) {
            if (!p.equals(projectPackaging)) continue;
            return false;
        }
        return true;
    }

    protected void checkEncoding() {
        if (this.isVerbose()) {
            LOG.info("Will check encoding: {}", (Object)this.getEncoding());
        }
        if (StringUtils.isEmpty((CharSequence)this.getEncoding())) {
            String sysEncoding = Charset.defaultCharset().displayName();
            LOG.warn("File encoding has not been set, using platform encoding {}, i.e. build is platform dependent!", (Object)sysEncoding);
            this.setEncoding(sysEncoding);
        }
    }

    protected void addResourceDir(File dir, String ... includes) {
        this.projectHelper.addResource(this.getProject(), dir.getAbsolutePath(), Arrays.asList(includes), null);
        if (this.isVerbose()) {
            LOG.info("add resource {} with includes {}", (Object)dir, (Object)includes);
        }
    }

    protected boolean hasClassPath() {
        return this.rejectPackaging("pom");
    }
}

