/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.docbook;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.DirectoryScanner;

public class OLinkDBUpdater {
    protected Log log;
    protected File sourceDirectory;
    protected File databaseDirectory;
    protected URI stylesheetLocation;

    public OLinkDBUpdater(Log log, File sourceDirectory, File databaseDirectory, URI stylesheetLocation) {
        this.log = log;
        this.sourceDirectory = sourceDirectory;
        this.databaseDirectory = databaseDirectory;
        this.stylesheetLocation = stylesheetLocation;
    }

    public void update() throws TransformerFactoryConfigurationError, TransformerException, IOException, URISyntaxException, InclusionScanException {
        StaleSourceScanner scanner = new StaleSourceScanner(0L, Collections.singleton("**/*.xml"), Collections.EMPTY_SET);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".xml", ".xml.db"));
        Set staleDocbookFiles = scanner.getIncludedSources(this.sourceDirectory, this.databaseDirectory);
        if (!staleDocbookFiles.isEmpty()) {
            DirectoryScanner docbookScanner = new DirectoryScanner();
            docbookScanner.setBasedir(this.sourceDirectory);
            docbookScanner.setFollowSymlinks(true);
            docbookScanner.setIncludes(new String[]{"**/*.xml"});
            docbookScanner.scan();
            String[] docbookFiles = docbookScanner.getIncludedFiles();
            this.prepareFileSystem(docbookFiles);
            this.updateOLinkDatabase(staleDocbookFiles);
            this.createMasterOLinkDatabase(docbookFiles);
        } else {
            this.log.info((CharSequence)"olink database up to date");
        }
    }

    protected void prepareFileSystem(String[] docbookFiles) {
        this.log.debug((CharSequence)("Creating database directories for the following files - " + Arrays.asList(docbookFiles).toString()));
        for (int fileIndex = 0; fileIndex < docbookFiles.length; ++fileIndex) {
            String docbookFile = docbookFiles[fileIndex];
            int lastFileSeparator = docbookFile.lastIndexOf(File.separator);
            if (lastFileSeparator <= 0) continue;
            File directory = new File(this.databaseDirectory, docbookFile.substring(0, lastFileSeparator));
            directory.mkdirs();
        }
    }

    protected void updateOLinkDatabase(Set docbookFiles) throws TransformerFactoryConfigurationError, TransformerException {
        this.log.info((CharSequence)"Loading olink database generation stylesheet");
        StreamSource docbookStyleSheetSource = new StreamSource(this.stylesheetLocation.resolve("xhtml/docbook.xsl").toString());
        Transformer olinkDBGenerator = TransformerFactory.newInstance().newTransformer(docbookStyleSheetSource);
        olinkDBGenerator.setParameter("collect.xref.targets", "only");
        olinkDBGenerator.setParameter("generate.toc", "");
        this.log.info((CharSequence)("Creating olink database for " + docbookFiles.size() + " Docbook stale file(s)"));
        Iterator filesIterator = docbookFiles.iterator();
        while (filesIterator.hasNext()) {
            File docbookFile = (File)filesIterator.next();
            this.log.debug((CharSequence)("Processing " + this.sourceDirectory + File.separator + docbookFile));
            String relativePath = docbookFile.getAbsolutePath().substring(this.sourceDirectory.getAbsolutePath().length());
            File databaseFile = new File(this.databaseDirectory, relativePath + ".db");
            StreamSource source = new StreamSource(docbookFile);
            StreamResult result = new StreamResult(new NullWriter());
            olinkDBGenerator.setParameter("targets.filename", databaseFile.getAbsolutePath());
            olinkDBGenerator.transform(source, result);
            this.log.debug((CharSequence)("Generated " + this.databaseDirectory + File.separator + docbookFile));
        }
    }

    protected void createMasterOLinkDatabase(String[] docbookFiles) throws IOException, URISyntaxException {
        this.log.info((CharSequence)"Creating master olink database file");
        BufferedWriter masterOlinkDBFile = new BufferedWriter(new FileWriter(this.databaseDirectory + System.getProperty("file.separator") + "olinkdb.xml"));
        masterOlinkDBFile.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("<!DOCTYPE targetset SYSTEM \"");
        masterOlinkDBFile.write(this.stylesheetLocation.resolve("common/targetdatabase.dtd").toString());
        masterOlinkDBFile.write("\" >");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("<targetset>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("  <sitemap>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("    <dir name=\"root\">");
        masterOlinkDBFile.newLine();
        this.writeDirectoryTagBody(masterOlinkDBFile, 1, "", docbookFiles);
        masterOlinkDBFile.write("    </dir>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("  </sitemap>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.write("</targetset>");
        masterOlinkDBFile.newLine();
        masterOlinkDBFile.close();
    }

    protected void writeDirectoryTagBody(BufferedWriter writer, int level, String currentDirectory, String[] files) throws IOException {
        int currentDirectoryLength = currentDirectory.length();
        String lastRelativeDirectory = "";
        LinkedList<String> subdirectory = new LinkedList<String>();
        for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
            String file = files[fileIndex];
            String relativeFile = file.substring(currentDirectoryLength);
            if (relativeFile.indexOf(File.separator) == -1) {
                String fileID = OLinkDBUpdater.computeFileID(file);
                writer.write(OLinkDBUpdater.indenting(level) + "<document targetdoc=\"");
                writer.write(fileID);
                writer.write("\" baseuri=\"");
                writer.write(relativeFile.substring(0, relativeFile.lastIndexOf(".")) + ".html\">");
                writer.write("<xi:include xmlns:xi=\"http://www.w3.org/2003/XInclude\" href=\"");
                writer.write(file.replace(File.separatorChar, '/') + ".db\"/>");
                writer.write("</document>");
                writer.newLine();
                continue;
            }
            String relativeDirectory = relativeFile.substring(0, relativeFile.indexOf(File.separator));
            if (!relativeDirectory.equals(lastRelativeDirectory)) {
                if (!subdirectory.isEmpty()) {
                    writer.write(OLinkDBUpdater.indenting(level) + "<dir name=\"" + lastRelativeDirectory + "\">");
                    writer.newLine();
                    this.writeDirectoryTagBody(writer, level + 1, currentDirectory + File.separator + lastRelativeDirectory, subdirectory.toArray(new String[0]));
                    writer.write(OLinkDBUpdater.indenting(level) + "</dir>");
                    writer.newLine();
                }
                lastRelativeDirectory = relativeDirectory;
                subdirectory.clear();
            }
            subdirectory.add(file);
        }
        if (!subdirectory.isEmpty()) {
            writer.write(OLinkDBUpdater.indenting(level) + "<dir name=\"" + lastRelativeDirectory + "\">");
            writer.newLine();
            this.writeDirectoryTagBody(writer, level + 1, currentDirectory + File.separator + lastRelativeDirectory, subdirectory.toArray(new String[0]));
            writer.write(OLinkDBUpdater.indenting(level) + "</dir>");
            writer.newLine();
        }
    }

    public static String computeFileID(String docbookFileName) {
        String fileID = docbookFileName;
        if (docbookFileName.indexOf(File.separator) == 0) {
            fileID = docbookFileName.substring(File.separator.length());
        }
        return fileID.replace(File.separatorChar, '-');
    }

    protected static String indenting(int level) {
        StringBuffer indent = new StringBuffer("      ");
        for (int currentLevel = 1; currentLevel < level; ++currentLevel) {
            indent.append("  ");
        }
        return indent.toString();
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void write(char[] cbuff, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

