/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.awt.Paint;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.TagListReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.jfree.chart.ChartColor;
import org.jfree.data.time.TimeSeries;

public class TaglistTimeChartStrategy
extends AbstractTimeChartStrategy {
    public TaglistTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        super(bundle, title, results, timeUnit, startDate, endDate);
    }

    public void fillDataset() {
        TimeSeries s1 = new TimeSeries(this.bundle.getString("report.taglist.label.nbclasses"), this.periodClass);
        TimeSeries s2 = new TimeSeries(this.bundle.getString("report.taglist.column.nboccurs"), this.periodClass);
        Iterator iter = this.mResults.iterator();
        while (iter.hasNext()) {
            TagListReportBean taglistReport = (TagListReportBean)iter.next();
            Date date = taglistReport.getDateGeneration();
            s1.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)taglistReport.getNbClasses());
            s2.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), (double)taglistReport.getNbTotal());
        }
        this.defaultdataset.addSeries(s1);
        this.defaultdataset.addSeries(s2);
    }

    public Paint[] getPaintColor() {
        return new Paint[]{ChartColor.GREEN, ChartColor.RED};
    }
}

