/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleError;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class CheckstyleReportBean
extends AbstractReportBean {
    private int nbClasses;
    private int nbInfos;
    private int nbWarnings;
    private int nbErrors;
    private int nbTotal;
    private List errors = new ArrayList();

    public CheckstyleReportBean() {
    }

    public CheckstyleReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public int getNbClasses() {
        return this.nbClasses;
    }

    public void setNbClasses(int nbClasses) {
        this.nbClasses = nbClasses;
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    public void setNbErrors(int nbErrors) {
        this.nbErrors = nbErrors;
    }

    public int getNbInfos() {
        return this.nbInfos;
    }

    public void setNbInfos(int nbInfos) {
        this.nbInfos = nbInfos;
    }

    public int getNbTotal() {
        return this.nbTotal;
    }

    public void setNbTotal(int nbTotal) {
        this.nbTotal = nbTotal;
    }

    public int getNbWarnings() {
        return this.nbWarnings;
    }

    public void setNbWarnings(int nbWarnings) {
        this.nbWarnings = nbWarnings;
    }

    public List getErrors() {
        return this.errors;
    }

    public void setErrors(List errorsList) {
        this.errors = errorsList;
    }

    public void addError(CheckstyleError error) {
        if (this.errors.isEmpty()) {
            this.errors.add(error);
        } else if (this.errors.contains(error)) {
            int index = this.errors.indexOf(error);
            int nbIter = ((CheckstyleError)this.errors.get(index)).getNbIteration();
            ((CheckstyleError)this.errors.get(index)).setNbIteration(nbIter + error.getNbIteration());
        } else {
            this.errors.add(error);
        }
    }

    public void addAllError(List errorsList) {
        if (this.errors.isEmpty()) {
            Iterator iter = errorsList.iterator();
            while (iter.hasNext()) {
                CheckstyleError error = (CheckstyleError)iter.next();
                this.errors.add((CheckstyleError)error.clone());
            }
        } else {
            Iterator iter = errorsList.iterator();
            while (iter.hasNext()) {
                CheckstyleError error = (CheckstyleError)iter.next();
                this.addError((CheckstyleError)error.clone());
            }
        }
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof CheckstyleReportBean) {
            this.nbClasses += ((CheckstyleReportBean)dashboardReport).getNbClasses();
            this.nbInfos += ((CheckstyleReportBean)dashboardReport).getNbInfos();
            this.nbWarnings += ((CheckstyleReportBean)dashboardReport).getNbWarnings();
            this.nbErrors += ((CheckstyleReportBean)dashboardReport).getNbErrors();
            this.nbTotal += ((CheckstyleReportBean)dashboardReport).getNbTotal();
            this.addAllError(((CheckstyleReportBean)dashboardReport).getErrors());
        }
    }

    protected Object clone() {
        CheckstyleReportBean clone = new CheckstyleReportBean(this.getDateGeneration());
        clone.setNbClasses(this.nbClasses);
        clone.setNbInfos(this.nbInfos);
        clone.setNbWarnings(this.nbWarnings);
        clone.setNbErrors(this.nbErrors);
        clone.setNbTotal(this.nbTotal);
        clone.addAllError(this.getErrors());
        return clone;
    }

    public double getPercentInfos() {
        return this.getPercentageValue(this.nbInfos, this.nbTotal);
    }

    public double getPercentErrors() {
        return this.getPercentageValue(this.nbErrors, this.nbTotal);
    }

    public double getPercentWarnings() {
        return this.getPercentageValue(this.nbWarnings, this.nbTotal);
    }
}

