/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;
import org.codehaus.mojo.chronos.common.model.ModelUtil;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSample;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public abstract class ResponsetimeSamples {
    private static final int PERCENTILE_95 = 95;
    private static final int PERCENTILE_99 = 99;
    protected final List<ResponsetimeSample> samples = new ArrayList<ResponsetimeSample>();
    protected int succeeded;

    public final void addAll(ResponsetimeSamples other) {
        for (ResponsetimeSample sample : other.samples) {
            this.add(sample);
        }
    }

    public final void add(ResponsetimeSample sample) {
        this.samples.add(sample);
        if (sample.isSuccess()) {
            ++this.succeeded;
        }
    }

    public final int size() {
        return this.samples.size();
    }

    public final double getSuccessrate() {
        return 100.0 * (double)this.getSucceeded() / (double)this.samples.size();
    }

    public final int getFailed() {
        return this.samples.size() - this.getSucceeded();
    }

    public final int getSucceeded() {
        return this.succeeded;
    }

    public final double getAverage() {
        return StatUtils.mean((double[])this.extractResponsetimes());
    }

    public final double getMin() {
        return StatUtils.min((double[])this.extractResponsetimes());
    }

    public final double getMax() {
        return StatUtils.max((double[])this.extractResponsetimes());
    }

    public final double getPercentile95() {
        return StatUtils.percentile((double[])this.extractResponsetimes(), (double)95.0);
    }

    public final double getPercentile99() {
        return StatUtils.percentile((double[])this.extractResponsetimes(), (double)99.0);
    }

    public final long getFirstTimestamp() {
        if (this.samples.isEmpty()) {
            return System.currentTimeMillis();
        }
        ResponsetimeSample responsetimeSample = this.samples.get(0);
        return responsetimeSample.getTimestamp();
    }

    public final double[] extractResponsetimes() {
        double[] responsetimes = new double[this.samples.size()];
        int i = 0;
        for (ResponsetimeSample sample : this.samples) {
            responsetimes[i++] = sample.getResponsetime();
        }
        return responsetimes;
    }

    public final void appendResponsetimes(TimeSeries series) {
        for (ResponsetimeSample sample : this.samples) {
            long delta = this.getFirstTimestamp();
            Millisecond timestamp = ModelUtil.createMillis(sample.getTimestamp() - delta);
            double responseTime = sample.getResponsetime();
            series.addOrUpdate((RegularTimePeriod)timestamp, responseTime);
        }
    }

    public final void appendThreadCounts(TimeSeries series, long threadCountDuration) {
        if (this.samples.size() > 0) {
            long firstSerial = this.getFirstTimestamp();
            HashMap<String, ResponsetimeSample> activeThreads = new HashMap<String, ResponsetimeSample>();
            for (ResponsetimeSample sample : this.samples) {
                int threadCount = activeThreads.size();
                Iterator it2 = activeThreads.keySet().iterator();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (sample.getTimestamp() <= ((ResponsetimeSample)activeThreads.get(key)).getTimestamp() + threadCountDuration) continue;
                    it2.remove();
                }
                activeThreads.put(sample.getThreadId(), sample);
                if (threadCount == activeThreads.size()) continue;
                series.addOrUpdate((RegularTimePeriod)ModelUtil.createMillis(sample.getTimestamp() - firstSerial), (double)threadCount);
                series.addOrUpdate((RegularTimePeriod)ModelUtil.createMillis(sample.getTimestamp() - firstSerial + 1L), (double)activeThreads.size());
            }
            ResponsetimeSample sample = this.samples.get(this.samples.size() - 1);
            series.addOrUpdate((RegularTimePeriod)ModelUtil.createMillis(sample.getTimestamp() - firstSerial + 1L), (double)activeThreads.size());
        }
    }

    public final TimeSeries createMovingThroughput(String name) {
        long firstAllowedTimestamp;
        TimeSeries series = new TimeSeries((Comparable)((Object)name), Millisecond.class);
        if (this.samples.isEmpty()) {
            return series;
        }
        Collections.sort(this.samples, new Comparator<ResponsetimeSample>(){

            @Override
            public int compare(ResponsetimeSample sample1, ResponsetimeSample sample2) {
                long endtime1 = sample1.getTimestamp() + (long)sample1.getResponsetime();
                long endtime2 = sample2.getTimestamp() + (long)sample2.getResponsetime();
                return (int)(endtime1 - endtime2);
            }
        });
        int periodLength = 1000;
        long rampUpTime = 0L;
        int measurements = 0;
        long periodStart = firstAllowedTimestamp = this.getFirstTimestamp() + rampUpTime;
        long periodEnd = periodStart + (long)periodLength;
        for (ResponsetimeSample sample : this.samples) {
            long sampleEndTime = sample.getTimestamp() + (long)sample.getResponsetime();
            if (periodStart <= sampleEndTime && sampleEndTime <= periodEnd) {
                ++measurements;
                continue;
            }
            if (periodStart > sampleEndTime || sampleEndTime <= periodEnd) continue;
            if (measurements > 0) {
                series.addOrUpdate((RegularTimePeriod)ModelUtil.createMillis(periodEnd - firstAllowedTimestamp), (double)measurements);
            } else {
                series.addOrUpdate((RegularTimePeriod)ModelUtil.createMillis(periodEnd - firstAllowedTimestamp), null);
            }
            measurements = 1;
            periodStart = periodEnd;
            periodEnd = periodStart + (long)periodLength;
        }
        return series;
    }

    public final double getMaxAverageThroughput(int averageduration) {
        TimeSeries series = this.createMovingThroughput("");
        TimeSeries averageseries = MovingAverage.createMovingAverage((TimeSeries)series, (String)"", (int)averageduration, (int)0);
        double max = 0.0;
        for (TimeSeriesDataItem item : averageseries.getItems()) {
            if (item.getValue() == null) continue;
            max = Math.max(max, item.getValue().doubleValue());
        }
        return max;
    }

    public final long getTotalTime() {
        ResponsetimeSample first = this.samples.get(0);
        ResponsetimeSample last = this.samples.get(this.samples.size() - 1);
        return last.getTimestamp() + (long)last.getResponsetime() - first.getTimestamp();
    }
}

